// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/archetypes/encoded_depth_image.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/blob.hpp"
#include "../components/colormap.hpp"
#include "../components/depth_meter.hpp"
#include "../components/draw_order.hpp"
#include "../components/fill_ratio.hpp"
#include "../components/media_type.hpp"
#include "../components/value_range.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: A depth image encoded with a codec (e.g. RVL or PNG).
    ///
    /// Rerun also supports uncompressed depth images with the [`archetypes.DepthImage`](https://rerun.io/docs/reference/types/archetypes/depth_image).
    ///
    /// ## Example
    ///
    /// ### Encoded depth image
    /// ![image](https://static.rerun.io/encoded_depth_image/d8180f8167278f9601808c360ba52eafaab52839/full.png)
    ///
    /// ```cpp
    /// #include <rerun.hpp>
    ///
    /// #include <filesystem>
    /// #include <fstream>
    /// #include <iostream>
    /// #include <vector>
    ///
    /// namespace fs = std::filesystem;
    ///
    /// int main(int argc, char* argv[]) {
    ///     if (argc <2) {
    ///         std::cerr <<"Usage: " <<argv[0] <<" <path_to_depth_image.[png|rvl]>" <<std::endl;
    ///         return 1;
    ///     }
    ///
    ///     const auto rec = rerun::RecordingStream("rerun_example_encoded_depth_image");
    ///     rec.spawn().exit_on_failure();
    ///
    ///     const auto depth_path = fs::path(argv[1]);
    ///     std::ifstream file(depth_path, std::ios::binary);
    ///     if (!file) {
    ///         std::cerr <<"Failed to open encoded depth image: " <<depth_path <<std::endl;
    ///         return 1;
    ///     }
    ///
    ///     std::vector<uint8_t> bytes{
    ///         std::istreambuf_iterator<char>(file),
    ///         std::istreambuf_iterator<char>()};
    ///     // Determine media type based on file extension
    ///     rerun::components::MediaType media_type;
    ///     if (depth_path.extension() == ".png") {
    ///         media_type = rerun::components::MediaType::png();
    ///     } else {
    ///         media_type = rerun::components::MediaType::rvl();
    ///     }
    ///
    ///     rec.log(
    ///         "depth/encoded",
    ///         rerun::archetypes::EncodedDepthImage()
    ///             .with_blob(rerun::components::Blob(
    ///                 rerun::Collection<uint8_t>::take_ownership(std::move(bytes))
    ///             ))
    ///             .with_media_type(media_type)
    ///             .with_meter(0.001f)
    ///     );
    /// }
    /// ```
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct EncodedDepthImage {
        /// The encoded depth payload.
        ///
        /// Supported are:
        /// * single channel PNG
        /// * RVL with ROS2 metadata (for details see <https://github.com/ros-perception/image_transport_plugins/tree/jazzy>)
        std::optional<ComponentBatch> blob;

        /// Media type of the blob, e.g.:
        ///
        ///  * `application/rvl` (RVL-compressed 16-bit)
        ///  * `image/png`
        std::optional<ComponentBatch> media_type;

        /// Conversion from native units to meters (e.g. `0.001` for millimeters).
        ///
        /// If omitted, the Viewer defaults to `1.0` for floating-point depth formats and `1000.0` for integer formats (millimeters).
        std::optional<ComponentBatch> meter;

        /// Optional colormap for visualization of decoded depth.
        std::optional<ComponentBatch> colormap;

        /// Optional visualization range for depth values.
        std::optional<ComponentBatch> depth_range;

        /// Optional point fill ratio for point-cloud projection.
        std::optional<ComponentBatch> point_fill_ratio;

        /// Optional 2D draw order.
        std::optional<ComponentBatch> draw_order;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.EncodedDepthImage";

        /// `ComponentDescriptor` for the `blob` field.
        static constexpr auto Descriptor_blob = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:blob",
            Loggable<rerun::components::Blob>::ComponentType
        );
        /// `ComponentDescriptor` for the `media_type` field.
        static constexpr auto Descriptor_media_type = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:media_type",
            Loggable<rerun::components::MediaType>::ComponentType
        );
        /// `ComponentDescriptor` for the `meter` field.
        static constexpr auto Descriptor_meter = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:meter",
            Loggable<rerun::components::DepthMeter>::ComponentType
        );
        /// `ComponentDescriptor` for the `colormap` field.
        static constexpr auto Descriptor_colormap = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:colormap",
            Loggable<rerun::components::Colormap>::ComponentType
        );
        /// `ComponentDescriptor` for the `depth_range` field.
        static constexpr auto Descriptor_depth_range = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:depth_range",
            Loggable<rerun::components::ValueRange>::ComponentType
        );
        /// `ComponentDescriptor` for the `point_fill_ratio` field.
        static constexpr auto Descriptor_point_fill_ratio = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:point_fill_ratio",
            Loggable<rerun::components::FillRatio>::ComponentType
        );
        /// `ComponentDescriptor` for the `draw_order` field.
        static constexpr auto Descriptor_draw_order = ComponentDescriptor(
            ArchetypeName, "EncodedDepthImage:draw_order",
            Loggable<rerun::components::DrawOrder>::ComponentType
        );

      public:
        EncodedDepthImage() = default;
        EncodedDepthImage(EncodedDepthImage&& other) = default;
        EncodedDepthImage(const EncodedDepthImage& other) = default;
        EncodedDepthImage& operator=(const EncodedDepthImage& other) = default;
        EncodedDepthImage& operator=(EncodedDepthImage&& other) = default;

        explicit EncodedDepthImage(rerun::components::Blob _blob)
            : blob(ComponentBatch::from_loggable(std::move(_blob), Descriptor_blob).value_or_throw()
              ) {}

        /// Update only some specific fields of a `EncodedDepthImage`.
        static EncodedDepthImage update_fields() {
            return EncodedDepthImage();
        }

        /// Clear all the fields of a `EncodedDepthImage`.
        static EncodedDepthImage clear_fields();

        /// The encoded depth payload.
        ///
        /// Supported are:
        /// * single channel PNG
        /// * RVL with ROS2 metadata (for details see <https://github.com/ros-perception/image_transport_plugins/tree/jazzy>)
        EncodedDepthImage with_blob(const rerun::components::Blob& _blob) && {
            blob = ComponentBatch::from_loggable(_blob, Descriptor_blob).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `blob` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_blob` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_blob(const Collection<rerun::components::Blob>& _blob) && {
            blob = ComponentBatch::from_loggable(_blob, Descriptor_blob).value_or_throw();
            return std::move(*this);
        }

        /// Media type of the blob, e.g.:
        ///
        ///  * `application/rvl` (RVL-compressed 16-bit)
        ///  * `image/png`
        EncodedDepthImage with_media_type(const rerun::components::MediaType& _media_type) && {
            media_type =
                ComponentBatch::from_loggable(_media_type, Descriptor_media_type).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `media_type` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_media_type` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_media_type(
            const Collection<rerun::components::MediaType>& _media_type
        ) && {
            media_type =
                ComponentBatch::from_loggable(_media_type, Descriptor_media_type).value_or_throw();
            return std::move(*this);
        }

        /// Conversion from native units to meters (e.g. `0.001` for millimeters).
        ///
        /// If omitted, the Viewer defaults to `1.0` for floating-point depth formats and `1000.0` for integer formats (millimeters).
        EncodedDepthImage with_meter(const rerun::components::DepthMeter& _meter) && {
            meter = ComponentBatch::from_loggable(_meter, Descriptor_meter).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `meter` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_meter` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_meter(const Collection<rerun::components::DepthMeter>& _meter
        ) && {
            meter = ComponentBatch::from_loggable(_meter, Descriptor_meter).value_or_throw();
            return std::move(*this);
        }

        /// Optional colormap for visualization of decoded depth.
        EncodedDepthImage with_colormap(const rerun::components::Colormap& _colormap) && {
            colormap =
                ComponentBatch::from_loggable(_colormap, Descriptor_colormap).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `colormap` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_colormap` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_colormap(
            const Collection<rerun::components::Colormap>& _colormap
        ) && {
            colormap =
                ComponentBatch::from_loggable(_colormap, Descriptor_colormap).value_or_throw();
            return std::move(*this);
        }

        /// Optional visualization range for depth values.
        EncodedDepthImage with_depth_range(const rerun::components::ValueRange& _depth_range) && {
            depth_range = ComponentBatch::from_loggable(_depth_range, Descriptor_depth_range)
                              .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `depth_range` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_depth_range` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_depth_range(
            const Collection<rerun::components::ValueRange>& _depth_range
        ) && {
            depth_range = ComponentBatch::from_loggable(_depth_range, Descriptor_depth_range)
                              .value_or_throw();
            return std::move(*this);
        }

        /// Optional point fill ratio for point-cloud projection.
        EncodedDepthImage with_point_fill_ratio(
            const rerun::components::FillRatio& _point_fill_ratio
        ) && {
            point_fill_ratio =
                ComponentBatch::from_loggable(_point_fill_ratio, Descriptor_point_fill_ratio)
                    .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `point_fill_ratio` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_point_fill_ratio` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_point_fill_ratio(
            const Collection<rerun::components::FillRatio>& _point_fill_ratio
        ) && {
            point_fill_ratio =
                ComponentBatch::from_loggable(_point_fill_ratio, Descriptor_point_fill_ratio)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Optional 2D draw order.
        EncodedDepthImage with_draw_order(const rerun::components::DrawOrder& _draw_order) && {
            draw_order =
                ComponentBatch::from_loggable(_draw_order, Descriptor_draw_order).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `draw_order` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_draw_order` should
        /// be used when logging a single row's worth of data.
        EncodedDepthImage with_many_draw_order(
            const Collection<rerun::components::DrawOrder>& _draw_order
        ) && {
            draw_order =
                ComponentBatch::from_loggable(_draw_order, Descriptor_draw_order).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::EncodedDepthImage> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::EncodedDepthImage& archetype
        );
    };
} // namespace rerun
