// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/archetypes/mcap_channel.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/channel_id.hpp"
#include "../components/key_value_pairs.hpp"
#include "../components/text.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: A channel within an MCAP file that defines how messages are structured and encoded.
    ///
    /// Channels in MCAP files group messages by topic and define their encoding format.
    /// Each channel has a unique identifier and specifies the message schema and encoding used
    /// for all messages published to that topic.
    ///
    /// See also `archetypes::McapMessage` for individual messages within a channel,
    /// `archetypes::McapSchema` for the data structure definitions, and the
    /// [MCAP specification](https://mcap.dev/) for complete format details.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct McapChannel {
        /// Unique identifier for this channel within the MCAP file.
        ///
        /// Channel IDs must be unique within a single MCAP file and are used to associate
        /// messages with their corresponding channel definition.
        std::optional<ComponentBatch> id;

        /// The topic name that this channel publishes to.
        ///
        /// Topics are hierarchical paths from the original robotics system (e.g., "/sensors/camera/image")
        /// that categorize and organize different data streams.
        /// Topics are separate from Rerun's entity paths, but they often can be mapped to them.
        std::optional<ComponentBatch> topic;

        /// The encoding format used for messages in this channel.
        ///
        /// Common encodings include:
        /// * `ros1` - ROS1 message format
        /// * `cdr` - Common Data Representation (CDR) message format, used by ROS2
        /// * `protobuf` - Protocol Buffers
        /// * `json` - JSON encoding
        std::optional<ComponentBatch> message_encoding;

        /// Additional metadata for this channel stored as key-value pairs.
        ///
        /// This can include channel-specific configuration, description, units, coordinate frames,
        /// or any other contextual information that helps interpret the data in this channel.
        std::optional<ComponentBatch> metadata;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.McapChannel";

        /// `ComponentDescriptor` for the `id` field.
        static constexpr auto Descriptor_id = ComponentDescriptor(
            ArchetypeName, "McapChannel:id", Loggable<rerun::components::ChannelId>::ComponentType
        );
        /// `ComponentDescriptor` for the `topic` field.
        static constexpr auto Descriptor_topic = ComponentDescriptor(
            ArchetypeName, "McapChannel:topic", Loggable<rerun::components::Text>::ComponentType
        );
        /// `ComponentDescriptor` for the `message_encoding` field.
        static constexpr auto Descriptor_message_encoding = ComponentDescriptor(
            ArchetypeName, "McapChannel:message_encoding",
            Loggable<rerun::components::Text>::ComponentType
        );
        /// `ComponentDescriptor` for the `metadata` field.
        static constexpr auto Descriptor_metadata = ComponentDescriptor(
            ArchetypeName, "McapChannel:metadata",
            Loggable<rerun::components::KeyValuePairs>::ComponentType
        );

      public:
        McapChannel() = default;
        McapChannel(McapChannel&& other) = default;
        McapChannel(const McapChannel& other) = default;
        McapChannel& operator=(const McapChannel& other) = default;
        McapChannel& operator=(McapChannel&& other) = default;

        explicit McapChannel(
            rerun::components::ChannelId _id, rerun::components::Text _topic,
            rerun::components::Text _message_encoding
        )
            : id(ComponentBatch::from_loggable(std::move(_id), Descriptor_id).value_or_throw()),
              topic(ComponentBatch::from_loggable(std::move(_topic), Descriptor_topic)
                        .value_or_throw()),
              message_encoding(ComponentBatch::from_loggable(
                                   std::move(_message_encoding), Descriptor_message_encoding
              )
                                   .value_or_throw()) {}

        /// Update only some specific fields of a `McapChannel`.
        static McapChannel update_fields() {
            return McapChannel();
        }

        /// Clear all the fields of a `McapChannel`.
        static McapChannel clear_fields();

        /// Unique identifier for this channel within the MCAP file.
        ///
        /// Channel IDs must be unique within a single MCAP file and are used to associate
        /// messages with their corresponding channel definition.
        McapChannel with_id(const rerun::components::ChannelId& _id) && {
            id = ComponentBatch::from_loggable(_id, Descriptor_id).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `id` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_id` should
        /// be used when logging a single row's worth of data.
        McapChannel with_many_id(const Collection<rerun::components::ChannelId>& _id) && {
            id = ComponentBatch::from_loggable(_id, Descriptor_id).value_or_throw();
            return std::move(*this);
        }

        /// The topic name that this channel publishes to.
        ///
        /// Topics are hierarchical paths from the original robotics system (e.g., "/sensors/camera/image")
        /// that categorize and organize different data streams.
        /// Topics are separate from Rerun's entity paths, but they often can be mapped to them.
        McapChannel with_topic(const rerun::components::Text& _topic) && {
            topic = ComponentBatch::from_loggable(_topic, Descriptor_topic).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `topic` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_topic` should
        /// be used when logging a single row's worth of data.
        McapChannel with_many_topic(const Collection<rerun::components::Text>& _topic) && {
            topic = ComponentBatch::from_loggable(_topic, Descriptor_topic).value_or_throw();
            return std::move(*this);
        }

        /// The encoding format used for messages in this channel.
        ///
        /// Common encodings include:
        /// * `ros1` - ROS1 message format
        /// * `cdr` - Common Data Representation (CDR) message format, used by ROS2
        /// * `protobuf` - Protocol Buffers
        /// * `json` - JSON encoding
        McapChannel with_message_encoding(const rerun::components::Text& _message_encoding) && {
            message_encoding =
                ComponentBatch::from_loggable(_message_encoding, Descriptor_message_encoding)
                    .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `message_encoding` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_message_encoding` should
        /// be used when logging a single row's worth of data.
        McapChannel with_many_message_encoding(
            const Collection<rerun::components::Text>& _message_encoding
        ) && {
            message_encoding =
                ComponentBatch::from_loggable(_message_encoding, Descriptor_message_encoding)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Additional metadata for this channel stored as key-value pairs.
        ///
        /// This can include channel-specific configuration, description, units, coordinate frames,
        /// or any other contextual information that helps interpret the data in this channel.
        McapChannel with_metadata(const rerun::components::KeyValuePairs& _metadata) && {
            metadata =
                ComponentBatch::from_loggable(_metadata, Descriptor_metadata).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `metadata` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_metadata` should
        /// be used when logging a single row's worth of data.
        McapChannel with_many_metadata(const Collection<rerun::components::KeyValuePairs>& _metadata
        ) && {
            metadata =
                ComponentBatch::from_loggable(_metadata, Descriptor_metadata).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::McapChannel> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::McapChannel& archetype
        );
    };
} // namespace rerun
