// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/archetypes/mcap_message.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/blob.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: The binary payload of a single MCAP message, without metadata.
    ///
    /// This archetype represents only the raw message data from an MCAP file. It does not include
    /// MCAP message metadata such as timestamps, channel IDs, sequence numbers, or publication times.
    /// The binary payload represents sensor data, commands, or other information encoded according
    /// to the format specified by the associated channel.
    ///
    /// See `archetypes::McapChannel` for channel definitions that specify message encoding,
    /// `archetypes::McapSchema` for data structure definitions, and the
    /// [MCAP specification](https://mcap.dev/) for complete format details.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct McapMessage {
        /// The raw message payload as a binary blob.
        ///
        /// This contains the actual message data encoded according to the format specified
        /// by the associated channel's `message_encoding` field. The structure and interpretation
        /// of this binary data depends on the encoding format (e.g., ros1, cdr, protobuf)
        /// and the message schema defined for the channel.
        std::optional<ComponentBatch> data;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.McapMessage";

        /// `ComponentDescriptor` for the `data` field.
        static constexpr auto Descriptor_data = ComponentDescriptor(
            ArchetypeName, "McapMessage:data", Loggable<rerun::components::Blob>::ComponentType
        );

      public:
        McapMessage() = default;
        McapMessage(McapMessage&& other) = default;
        McapMessage(const McapMessage& other) = default;
        McapMessage& operator=(const McapMessage& other) = default;
        McapMessage& operator=(McapMessage&& other) = default;

        explicit McapMessage(rerun::components::Blob _data)
            : data(ComponentBatch::from_loggable(std::move(_data), Descriptor_data).value_or_throw()
              ) {}

        /// Update only some specific fields of a `McapMessage`.
        static McapMessage update_fields() {
            return McapMessage();
        }

        /// Clear all the fields of a `McapMessage`.
        static McapMessage clear_fields();

        /// The raw message payload as a binary blob.
        ///
        /// This contains the actual message data encoded according to the format specified
        /// by the associated channel's `message_encoding` field. The structure and interpretation
        /// of this binary data depends on the encoding format (e.g., ros1, cdr, protobuf)
        /// and the message schema defined for the channel.
        McapMessage with_data(const rerun::components::Blob& _data) && {
            data = ComponentBatch::from_loggable(_data, Descriptor_data).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `data` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_data` should
        /// be used when logging a single row's worth of data.
        McapMessage with_many_data(const Collection<rerun::components::Blob>& _data) && {
            data = ComponentBatch::from_loggable(_data, Descriptor_data).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::McapMessage> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::McapMessage& archetype
        );
    };
} // namespace rerun
