// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/archetypes/transform_axes3d.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/axis_length.hpp"
#include "../components/show_labels.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: A visual representation of a `archetypes::Transform3D`.
    ///
    /// ## Example
    ///
    /// ### Visual representation of a transform as three arrows
    /// ![image](https://static.rerun.io/transform3d_axes/574c482088e9d317b19127fc8bef957dbfd3abe8/full.png)
    ///
    /// ```cpp
    /// #include <rerun.hpp>
    ///
    /// int main() {
    ///     const auto rec = rerun::RecordingStream("rerun_example_transform3d_axes");
    ///     rec.spawn().exit_on_failure();
    ///
    ///     rec.set_time_sequence("step", 0);
    ///
    ///     rec.log("base", rerun::Transform3D(), rerun::TransformAxes3D(1.0));
    ///
    ///     for (int deg = 0; deg <360; deg++) {
    ///         rec.set_time_sequence("step", deg);
    ///
    ///         rec.log(
    ///             "base/rotated",
    ///             rerun::Transform3D().with_rotation_axis_angle(rerun::RotationAxisAngle(
    ///                 {1.0f, 1.0f, 1.0f},
    ///                 rerun::Angle::degrees(static_cast<float>(deg))
    ///             )),
    ///             rerun::TransformAxes3D(0.5)
    ///         );
    ///
    ///         rec.log(
    ///             "base/rotated/translated",
    ///             rerun::Transform3D().with_translation({2.0f, 0.0f, 0.0f}),
    ///             rerun::TransformAxes3D(0.5)
    ///         );
    ///     }
    /// }
    /// ```
    struct TransformAxes3D {
        /// Visual length of the 3 axes.
        ///
        /// The length is interpreted in the local coordinate system of the transform.
        /// If the transform is scaled, the axes will be scaled accordingly.
        std::optional<ComponentBatch> axis_length;

        /// Whether to show a text label with the corresponding frame.
        std::optional<ComponentBatch> show_frame;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.TransformAxes3D";

        /// `ComponentDescriptor` for the `axis_length` field.
        static constexpr auto Descriptor_axis_length = ComponentDescriptor(
            ArchetypeName, "TransformAxes3D:axis_length",
            Loggable<rerun::components::AxisLength>::ComponentType
        );
        /// `ComponentDescriptor` for the `show_frame` field.
        static constexpr auto Descriptor_show_frame = ComponentDescriptor(
            ArchetypeName, "TransformAxes3D:show_frame",
            Loggable<rerun::components::ShowLabels>::ComponentType
        );

      public:
        TransformAxes3D() = default;
        TransformAxes3D(TransformAxes3D&& other) = default;
        TransformAxes3D(const TransformAxes3D& other) = default;
        TransformAxes3D& operator=(const TransformAxes3D& other) = default;
        TransformAxes3D& operator=(TransformAxes3D&& other) = default;

        explicit TransformAxes3D(rerun::components::AxisLength _axis_length)
            : axis_length(
                  ComponentBatch::from_loggable(std::move(_axis_length), Descriptor_axis_length)
                      .value_or_throw()
              ) {}

        /// Update only some specific fields of a `TransformAxes3D`.
        static TransformAxes3D update_fields() {
            return TransformAxes3D();
        }

        /// Clear all the fields of a `TransformAxes3D`.
        static TransformAxes3D clear_fields();

        /// Visual length of the 3 axes.
        ///
        /// The length is interpreted in the local coordinate system of the transform.
        /// If the transform is scaled, the axes will be scaled accordingly.
        TransformAxes3D with_axis_length(const rerun::components::AxisLength& _axis_length) && {
            axis_length = ComponentBatch::from_loggable(_axis_length, Descriptor_axis_length)
                              .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `axis_length` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_axis_length` should
        /// be used when logging a single row's worth of data.
        TransformAxes3D with_many_axis_length(
            const Collection<rerun::components::AxisLength>& _axis_length
        ) && {
            axis_length = ComponentBatch::from_loggable(_axis_length, Descriptor_axis_length)
                              .value_or_throw();
            return std::move(*this);
        }

        /// Whether to show a text label with the corresponding frame.
        TransformAxes3D with_show_frame(const rerun::components::ShowLabels& _show_frame) && {
            show_frame =
                ComponentBatch::from_loggable(_show_frame, Descriptor_show_frame).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `show_frame` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_show_frame` should
        /// be used when logging a single row's worth of data.
        TransformAxes3D with_many_show_frame(
            const Collection<rerun::components::ShowLabels>& _show_frame
        ) && {
            show_frame =
                ComponentBatch::from_loggable(_show_frame, Descriptor_show_frame).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::TransformAxes3D> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::TransformAxes3D& archetype
        );
    };
} // namespace rerun
