// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/archetypes/active_visualizers.fbs".

#pragma once

#include "../../blueprint/components/visualizer_instruction_id.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Override the visualizers for an entity.
    ///
    /// This archetype is a stop-gap mechanism based on the current implementation details
    /// of the visualizer system. It is not intended to be a long-term solution, but provides
    /// enough utility to be useful in the short term.
    ///
    /// This can only be used as part of blueprints. It will have no effect if used
    /// in a regular entity.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct ActiveVisualizers {
        /// Id's of the visualizers that should be active.
        std::optional<ComponentBatch> instruction_ids;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] =
            "rerun.blueprint.archetypes.ActiveVisualizers";

        /// `ComponentDescriptor` for the `instruction_ids` field.
        static constexpr auto Descriptor_instruction_ids = ComponentDescriptor(
            ArchetypeName, "ActiveVisualizers:instruction_ids",
            Loggable<rerun::blueprint::components::VisualizerInstructionId>::ComponentType
        );

      public:
        ActiveVisualizers() = default;
        ActiveVisualizers(ActiveVisualizers&& other) = default;
        ActiveVisualizers(const ActiveVisualizers& other) = default;
        ActiveVisualizers& operator=(const ActiveVisualizers& other) = default;
        ActiveVisualizers& operator=(ActiveVisualizers&& other) = default;

        explicit ActiveVisualizers(
            Collection<rerun::blueprint::components::VisualizerInstructionId> _instruction_ids
        )
            : instruction_ids(ComponentBatch::from_loggable(
                                  std::move(_instruction_ids), Descriptor_instruction_ids
              )
                                  .value_or_throw()) {}

        /// Update only some specific fields of a `ActiveVisualizers`.
        static ActiveVisualizers update_fields() {
            return ActiveVisualizers();
        }

        /// Clear all the fields of a `ActiveVisualizers`.
        static ActiveVisualizers clear_fields();

        /// Id's of the visualizers that should be active.
        ActiveVisualizers with_instruction_ids(
            const Collection<rerun::blueprint::components::VisualizerInstructionId>&
                _instruction_ids
        ) && {
            instruction_ids =
                ComponentBatch::from_loggable(_instruction_ids, Descriptor_instruction_ids)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::ActiveVisualizers> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::ActiveVisualizers& archetype
        );
    };
} // namespace rerun
