// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/archetypes/spatial_information.fbs".

#pragma once

#include "../../blueprint/components/enabled.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../components/transform_frame_id.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: This configures extra drawing config for the 3D view.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct SpatialInformation {
        /// The target reference frame for all transformations.
        ///
        /// Defaults to the coordinate frame used by the space origin entity.
        std::optional<ComponentBatch> target_frame;

        /// Whether axes should be shown at the origin.
        std::optional<ComponentBatch> show_axes;

        /// Whether the bounding box should be shown.
        std::optional<ComponentBatch> show_bounding_box;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] =
            "rerun.blueprint.archetypes.SpatialInformation";

        /// `ComponentDescriptor` for the `target_frame` field.
        static constexpr auto Descriptor_target_frame = ComponentDescriptor(
            ArchetypeName, "SpatialInformation:target_frame",
            Loggable<rerun::components::TransformFrameId>::ComponentType
        );
        /// `ComponentDescriptor` for the `show_axes` field.
        static constexpr auto Descriptor_show_axes = ComponentDescriptor(
            ArchetypeName, "SpatialInformation:show_axes",
            Loggable<rerun::blueprint::components::Enabled>::ComponentType
        );
        /// `ComponentDescriptor` for the `show_bounding_box` field.
        static constexpr auto Descriptor_show_bounding_box = ComponentDescriptor(
            ArchetypeName, "SpatialInformation:show_bounding_box",
            Loggable<rerun::blueprint::components::Enabled>::ComponentType
        );

      public:
        SpatialInformation() = default;
        SpatialInformation(SpatialInformation&& other) = default;
        SpatialInformation(const SpatialInformation& other) = default;
        SpatialInformation& operator=(const SpatialInformation& other) = default;
        SpatialInformation& operator=(SpatialInformation&& other) = default;

        explicit SpatialInformation(rerun::components::TransformFrameId _target_frame)
            : target_frame(
                  ComponentBatch::from_loggable(std::move(_target_frame), Descriptor_target_frame)
                      .value_or_throw()
              ) {}

        /// Update only some specific fields of a `SpatialInformation`.
        static SpatialInformation update_fields() {
            return SpatialInformation();
        }

        /// Clear all the fields of a `SpatialInformation`.
        static SpatialInformation clear_fields();

        /// The target reference frame for all transformations.
        ///
        /// Defaults to the coordinate frame used by the space origin entity.
        SpatialInformation with_target_frame(
            const rerun::components::TransformFrameId& _target_frame
        ) && {
            target_frame = ComponentBatch::from_loggable(_target_frame, Descriptor_target_frame)
                               .value_or_throw();
            return std::move(*this);
        }

        /// Whether axes should be shown at the origin.
        SpatialInformation with_show_axes(const rerun::blueprint::components::Enabled& _show_axes
        ) && {
            show_axes =
                ComponentBatch::from_loggable(_show_axes, Descriptor_show_axes).value_or_throw();
            return std::move(*this);
        }

        /// Whether the bounding box should be shown.
        SpatialInformation with_show_bounding_box(
            const rerun::blueprint::components::Enabled& _show_bounding_box
        ) && {
            show_bounding_box =
                ComponentBatch::from_loggable(_show_bounding_box, Descriptor_show_bounding_box)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::SpatialInformation> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::SpatialInformation& archetype
        );
    };
} // namespace rerun
