// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/archetypes/text_log_columns.fbs".

#pragma once

#include "../../blueprint/components/text_log_column.hpp"
#include "../../blueprint/components/timeline_column.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Configuration of the text log columns.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct TextLogColumns {
        /// What timeline columns to show.
        ///
        /// Defaults to displaying all timelines.
        std::optional<ComponentBatch> timeline_columns;

        /// All columns to be displayed.
        ///
        /// Defaults to showing all text log column kinds in the order of the enum.
        std::optional<ComponentBatch> text_log_columns;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.TextLogColumns";

        /// `ComponentDescriptor` for the `timeline_columns` field.
        static constexpr auto Descriptor_timeline_columns = ComponentDescriptor(
            ArchetypeName, "TextLogColumns:timeline_columns",
            Loggable<rerun::blueprint::components::TimelineColumn>::ComponentType
        );
        /// `ComponentDescriptor` for the `text_log_columns` field.
        static constexpr auto Descriptor_text_log_columns = ComponentDescriptor(
            ArchetypeName, "TextLogColumns:text_log_columns",
            Loggable<rerun::blueprint::components::TextLogColumn>::ComponentType
        );

      public:
        TextLogColumns() = default;
        TextLogColumns(TextLogColumns&& other) = default;
        TextLogColumns(const TextLogColumns& other) = default;
        TextLogColumns& operator=(const TextLogColumns& other) = default;
        TextLogColumns& operator=(TextLogColumns&& other) = default;

        /// Update only some specific fields of a `TextLogColumns`.
        static TextLogColumns update_fields() {
            return TextLogColumns();
        }

        /// Clear all the fields of a `TextLogColumns`.
        static TextLogColumns clear_fields();

        /// What timeline columns to show.
        ///
        /// Defaults to displaying all timelines.
        TextLogColumns with_timeline_columns(
            const Collection<rerun::blueprint::components::TimelineColumn>& _timeline_columns
        ) && {
            timeline_columns =
                ComponentBatch::from_loggable(_timeline_columns, Descriptor_timeline_columns)
                    .value_or_throw();
            return std::move(*this);
        }

        /// All columns to be displayed.
        ///
        /// Defaults to showing all text log column kinds in the order of the enum.
        TextLogColumns with_text_log_columns(
            const Collection<rerun::blueprint::components::TextLogColumn>& _text_log_columns
        ) && {
            text_log_columns =
                ComponentBatch::from_loggable(_text_log_columns, Descriptor_text_log_columns)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::TextLogColumns> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::TextLogColumns& archetype
        );
    };
} // namespace rerun
