// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/archetypes/text_log_format.fbs".

#pragma once

#include "../../blueprint/components/enabled.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Configuration of the text log rows.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct TextLogFormat {
        /// Whether to use a monospace font for the log message body.
        ///
        /// Defaults to not being enabled.
        std::optional<ComponentBatch> monospace_body;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.TextLogFormat";

        /// `ComponentDescriptor` for the `monospace_body` field.
        static constexpr auto Descriptor_monospace_body = ComponentDescriptor(
            ArchetypeName, "TextLogFormat:monospace_body",
            Loggable<rerun::blueprint::components::Enabled>::ComponentType
        );

      public:
        TextLogFormat() = default;
        TextLogFormat(TextLogFormat&& other) = default;
        TextLogFormat(const TextLogFormat& other) = default;
        TextLogFormat& operator=(const TextLogFormat& other) = default;
        TextLogFormat& operator=(TextLogFormat&& other) = default;

        /// Update only some specific fields of a `TextLogFormat`.
        static TextLogFormat update_fields() {
            return TextLogFormat();
        }

        /// Clear all the fields of a `TextLogFormat`.
        static TextLogFormat clear_fields();

        /// Whether to use a monospace font for the log message body.
        ///
        /// Defaults to not being enabled.
        TextLogFormat with_monospace_body(
            const rerun::blueprint::components::Enabled& _monospace_body
        ) && {
            monospace_body =
                ComponentBatch::from_loggable(_monospace_body, Descriptor_monospace_body)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::TextLogFormat> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::TextLogFormat& archetype
        );
    };
} // namespace rerun
