// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/archetypes/time_axis.fbs".

#pragma once

#include "../../blueprint/components/link_axis.hpp"
#include "../../blueprint/components/lock_range_during_zoom.hpp"
#include "../../blueprint/components/time_range.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Configuration for the time (X) axis of a plot.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct TimeAxis {
        /// How should the horizontal/X/time axis be linked across multiple plots?
        ///
        /// Linking with global will ignore `view_range`.
        std::optional<ComponentBatch> link;

        /// The view range of the horizontal/X/time axis.
        std::optional<ComponentBatch> view_range;

        /// If enabled, the X axis range will remain locked to the specified range when zooming.
        std::optional<ComponentBatch> zoom_lock;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.TimeAxis";

        /// `ComponentDescriptor` for the `link` field.
        static constexpr auto Descriptor_link = ComponentDescriptor(
            ArchetypeName, "TimeAxis:link",
            Loggable<rerun::blueprint::components::LinkAxis>::ComponentType
        );
        /// `ComponentDescriptor` for the `view_range` field.
        static constexpr auto Descriptor_view_range = ComponentDescriptor(
            ArchetypeName, "TimeAxis:view_range",
            Loggable<rerun::blueprint::components::TimeRange>::ComponentType
        );
        /// `ComponentDescriptor` for the `zoom_lock` field.
        static constexpr auto Descriptor_zoom_lock = ComponentDescriptor(
            ArchetypeName, "TimeAxis:zoom_lock",
            Loggable<rerun::blueprint::components::LockRangeDuringZoom>::ComponentType
        );

      public:
        TimeAxis() = default;
        TimeAxis(TimeAxis&& other) = default;
        TimeAxis(const TimeAxis& other) = default;
        TimeAxis& operator=(const TimeAxis& other) = default;
        TimeAxis& operator=(TimeAxis&& other) = default;

        /// Update only some specific fields of a `TimeAxis`.
        static TimeAxis update_fields() {
            return TimeAxis();
        }

        /// Clear all the fields of a `TimeAxis`.
        static TimeAxis clear_fields();

        /// How should the horizontal/X/time axis be linked across multiple plots?
        ///
        /// Linking with global will ignore `view_range`.
        TimeAxis with_link(const rerun::blueprint::components::LinkAxis& _link) && {
            link = ComponentBatch::from_loggable(_link, Descriptor_link).value_or_throw();
            return std::move(*this);
        }

        /// The view range of the horizontal/X/time axis.
        TimeAxis with_view_range(const rerun::blueprint::components::TimeRange& _view_range) && {
            view_range =
                ComponentBatch::from_loggable(_view_range, Descriptor_view_range).value_or_throw();
            return std::move(*this);
        }

        /// If enabled, the X axis range will remain locked to the specified range when zooming.
        TimeAxis with_zoom_lock(const rerun::blueprint::components::LockRangeDuringZoom& _zoom_lock
        ) && {
            zoom_lock =
                ComponentBatch::from_loggable(_zoom_lock, Descriptor_zoom_lock).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::TimeAxis> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::TimeAxis& archetype
        );
    };
} // namespace rerun
