// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/archetypes/visualizer_instruction.fbs".

#pragma once

#include "../../blueprint/components/visualizer_component_mapping.hpp"
#include "../../blueprint/components/visualizer_type.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: A visualizer instruction for an entity.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct VisualizerInstruction {
        /// The type of the visualizer.
        std::optional<ComponentBatch> visualizer_type;

        /// The component mapping pairs.
        std::optional<ComponentBatch> component_map;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] =
            "rerun.blueprint.archetypes.VisualizerInstruction";

        /// `ComponentDescriptor` for the `visualizer_type` field.
        static constexpr auto Descriptor_visualizer_type = ComponentDescriptor(
            ArchetypeName, "VisualizerInstruction:visualizer_type",
            Loggable<rerun::blueprint::components::VisualizerType>::ComponentType
        );
        /// `ComponentDescriptor` for the `component_map` field.
        static constexpr auto Descriptor_component_map = ComponentDescriptor(
            ArchetypeName, "VisualizerInstruction:component_map",
            Loggable<rerun::blueprint::components::VisualizerComponentMapping>::ComponentType
        );

      public:
        VisualizerInstruction() = default;
        VisualizerInstruction(VisualizerInstruction&& other) = default;
        VisualizerInstruction(const VisualizerInstruction& other) = default;
        VisualizerInstruction& operator=(const VisualizerInstruction& other) = default;
        VisualizerInstruction& operator=(VisualizerInstruction&& other) = default;

        explicit VisualizerInstruction(rerun::blueprint::components::VisualizerType _visualizer_type
        )
            : visualizer_type(ComponentBatch::from_loggable(
                                  std::move(_visualizer_type), Descriptor_visualizer_type
              )
                                  .value_or_throw()) {}

        /// Update only some specific fields of a `VisualizerInstruction`.
        static VisualizerInstruction update_fields() {
            return VisualizerInstruction();
        }

        /// Clear all the fields of a `VisualizerInstruction`.
        static VisualizerInstruction clear_fields();

        /// The type of the visualizer.
        VisualizerInstruction with_visualizer_type(
            const rerun::blueprint::components::VisualizerType& _visualizer_type
        ) && {
            visualizer_type =
                ComponentBatch::from_loggable(_visualizer_type, Descriptor_visualizer_type)
                    .value_or_throw();
            return std::move(*this);
        }

        /// The component mapping pairs.
        VisualizerInstruction with_component_map(
            const Collection<rerun::blueprint::components::VisualizerComponentMapping>&
                _component_map
        ) && {
            component_map = ComponentBatch::from_loggable(_component_map, Descriptor_component_map)
                                .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::VisualizerInstruction> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::VisualizerInstruction& archetype
        );
    };
} // namespace rerun
