// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/components/near_clip_plane.fbs".

#pragma once

#include "../../datatypes/float32.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <memory>

namespace rerun::blueprint::components {
    /// **Component**: Distance to the near clip plane used for `Spatial2DView`.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct NearClipPlane {
        /// Distance to the near clip plane in 3D scene units.
        rerun::datatypes::Float32 near_clip_plane;

      public:
        NearClipPlane() = default;

        NearClipPlane(rerun::datatypes::Float32 near_clip_plane_)
            : near_clip_plane(near_clip_plane_) {}

        NearClipPlane& operator=(rerun::datatypes::Float32 near_clip_plane_) {
            near_clip_plane = near_clip_plane_;
            return *this;
        }

        NearClipPlane(float value_) : near_clip_plane(value_) {}

        NearClipPlane& operator=(float value_) {
            near_clip_plane = value_;
            return *this;
        }

        /// Cast to the underlying Float32 datatype
        operator rerun::datatypes::Float32() const {
            return near_clip_plane;
        }
    };
} // namespace rerun::blueprint::components

namespace rerun {
    static_assert(
        sizeof(rerun::datatypes::Float32) == sizeof(blueprint::components::NearClipPlane)
    );

    /// \private
    template <>
    struct Loggable<blueprint::components::NearClipPlane> {
        static constexpr std::string_view ComponentType =
            "rerun.blueprint.components.NearClipPlane";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Float32>::arrow_datatype();
        }

        /// Serializes an array of `rerun::blueprint:: components::NearClipPlane` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const blueprint::components::NearClipPlane* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Float32>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Float32>::to_arrow(
                    &instances->near_clip_plane,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
