// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/blueprint/components/visualizer_instruction_id.fbs".

#pragma once

#include "../../datatypes/uuid.hpp"
#include "../../result.hpp"

#include <array>
#include <cstdint>
#include <memory>

namespace rerun::blueprint::components {
    /// **Component**: ID for a visualizer instruction.
    ///
    /// IDs are only guaranteed to be unique in the scope of a view.
    /// For details see `archetypes::ActiveVisualizers`.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct VisualizerInstructionId {
        /// IDs of a single visualizer instruction.
        rerun::datatypes::Uuid visualizer;

      public:
        VisualizerInstructionId() = default;

        VisualizerInstructionId(rerun::datatypes::Uuid visualizer_) : visualizer(visualizer_) {}

        VisualizerInstructionId& operator=(rerun::datatypes::Uuid visualizer_) {
            visualizer = visualizer_;
            return *this;
        }

        VisualizerInstructionId(std::array<uint8_t, 16> bytes_) : visualizer(bytes_) {}

        VisualizerInstructionId& operator=(std::array<uint8_t, 16> bytes_) {
            visualizer = bytes_;
            return *this;
        }

        /// Cast to the underlying Uuid datatype
        operator rerun::datatypes::Uuid() const {
            return visualizer;
        }
    };
} // namespace rerun::blueprint::components

namespace rerun {
    static_assert(
        sizeof(rerun::datatypes::Uuid) == sizeof(blueprint::components::VisualizerInstructionId)
    );

    /// \private
    template <>
    struct Loggable<blueprint::components::VisualizerInstructionId> {
        static constexpr std::string_view ComponentType =
            "rerun.blueprint.components.VisualizerInstructionId";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Uuid>::arrow_datatype();
        }

        /// Serializes an array of `rerun::blueprint:: components::VisualizerInstructionId` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const blueprint::components::VisualizerInstructionId* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Uuid>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Uuid>::to_arrow(
                    &instances->visualizer,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
