// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/draw_order.fbs".

#pragma once

#include "../datatypes/float32.hpp"
#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: Draw order of 2D elements. Higher values are drawn on top of lower values.
    ///
    /// An entity can have only a single draw order component.
    /// Within an entity draw order is governed by the order of the components.
    ///
    /// Draw order for entities with the same draw order is generally undefined.
    struct DrawOrder {
        rerun::datatypes::Float32 value;

      public:
        DrawOrder() = default;

        DrawOrder(rerun::datatypes::Float32 value_) : value(value_) {}

        DrawOrder& operator=(rerun::datatypes::Float32 value_) {
            value = value_;
            return *this;
        }

        DrawOrder(float value_) : value(value_) {}

        DrawOrder& operator=(float value_) {
            value = value_;
            return *this;
        }

        /// Cast to the underlying Float32 datatype
        operator rerun::datatypes::Float32() const {
            return value;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Float32) == sizeof(components::DrawOrder));

    /// \private
    template <>
    struct Loggable<components::DrawOrder> {
        static constexpr std::string_view ComponentType = "rerun.components.DrawOrder";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Float32>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::DrawOrder` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::DrawOrder* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Float32>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Float32>::to_arrow(
                    &instances->value,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
