// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/fill_mode.fbs".

#pragma once

#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace arrow {
    /// \private
    template <typename T>
    class NumericBuilder;

    class Array;
    class DataType;
    class UInt8Type;
    using UInt8Builder = NumericBuilder<UInt8Type>;
} // namespace arrow

namespace rerun::components {
    /// **Component**: How a geometric shape is drawn and colored.
    enum class FillMode : uint8_t {

        /// Lines are drawn around the parts of the shape which directly correspond to the logged data.
        ///
        /// Examples of what this means:
        ///
        /// * An `archetypes::Ellipsoids3D` will draw three axis-aligned ellipses that are cross-sections
        ///   of each ellipsoid, each of which displays two out of three of the sizes of the ellipsoid.
        /// * For `archetypes::Boxes3D`, it is the edges of the box, identical to `components::FillMode::DenseWireframe`.
        MajorWireframe = 1,

        /// Many lines are drawn to represent the surface of the shape in a see-through fashion.
        ///
        /// Examples of what this means:
        ///
        /// * An `archetypes::Ellipsoids3D` will draw a wireframe triangle mesh that approximates each
        ///   ellipsoid.
        /// * For `archetypes::Boxes3D`, it is the edges of the box, identical to `components::FillMode::MajorWireframe`.
        DenseWireframe = 2,

        /// The surface of the shape is filled in with a solid color. No lines are drawn.
        Solid = 3,
    };
} // namespace rerun::components

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<components::FillMode> {
        static constexpr std::string_view ComponentType = "rerun.components.FillMode";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::components::FillMode` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::FillMode* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::UInt8Builder* builder, const components::FillMode* elements, size_t num_elements
        );
    };
} // namespace rerun
