// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/latlon.fbs".

#pragma once

#include "../datatypes/dvec2d.hpp"
#include "../result.hpp"

#include <array>
#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: A geospatial position expressed in [EPSG:4326](https://epsg.io/4326) latitude and longitude (North/East-positive degrees).
    struct LatLon {
        rerun::datatypes::DVec2D lat_lon;

      public: // START of extensions from lat_lon_ext.cpp:
        /// Construct LatLon from x/y values.
        LatLon(double lat, double lon) : lat_lon{lat, lon} {}

        double latitude() const {
            return lat_lon.x();
        }

        double longitude() const {
            return lat_lon.y();
        }

        // END of extensions from lat_lon_ext.cpp, start of generated code:

      public:
        LatLon() = default;

        LatLon(rerun::datatypes::DVec2D lat_lon_) : lat_lon(lat_lon_) {}

        LatLon& operator=(rerun::datatypes::DVec2D lat_lon_) {
            lat_lon = lat_lon_;
            return *this;
        }

        LatLon(std::array<double, 2> xy_) : lat_lon(xy_) {}

        LatLon& operator=(std::array<double, 2> xy_) {
            lat_lon = xy_;
            return *this;
        }

        /// Cast to the underlying DVec2D datatype
        operator rerun::datatypes::DVec2D() const {
            return lat_lon;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::DVec2D) == sizeof(components::LatLon));

    /// \private
    template <>
    struct Loggable<components::LatLon> {
        static constexpr std::string_view ComponentType = "rerun.components.LatLon";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::DVec2D>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::LatLon` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::LatLon* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::DVec2D>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::DVec2D>::to_arrow(
                    &instances->lat_lon,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
