// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/pinhole_projection.fbs".

#pragma once

#include "../datatypes/mat3x3.hpp"
#include "../result.hpp"

#include <array>
#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: Camera projection, from image coordinates to view coordinates.
    ///
    /// Child from parent.
    /// Image coordinates from camera view coordinates.
    ///
    /// Example:
    /// ```text
    /// 1496.1     0.0  980.5
    ///    0.0  1496.1  744.5
    ///    0.0     0.0    1.0
    /// ```
    struct PinholeProjection {
        rerun::datatypes::Mat3x3 image_from_camera;

      public: // START of extensions from pinhole_projection_ext.cpp:
        /// Construct a new 3x3 pinhole matrix from a pointer to 9 floats (in column major order).
        static PinholeProjection from_mat3x3(const float* elements) {
            return PinholeProjection(rerun::datatypes::Mat3x3(elements));
        }

        // END of extensions from pinhole_projection_ext.cpp, start of generated code:

      public:
        PinholeProjection() = default;

        PinholeProjection(rerun::datatypes::Mat3x3 image_from_camera_)
            : image_from_camera(image_from_camera_) {}

        PinholeProjection& operator=(rerun::datatypes::Mat3x3 image_from_camera_) {
            image_from_camera = image_from_camera_;
            return *this;
        }

        PinholeProjection(std::array<float, 9> flat_columns_) : image_from_camera(flat_columns_) {}

        PinholeProjection& operator=(std::array<float, 9> flat_columns_) {
            image_from_camera = flat_columns_;
            return *this;
        }

        /// Cast to the underlying Mat3x3 datatype
        operator rerun::datatypes::Mat3x3() const {
            return image_from_camera;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Mat3x3) == sizeof(components::PinholeProjection));

    /// \private
    template <>
    struct Loggable<components::PinholeProjection> {
        static constexpr std::string_view ComponentType = "rerun.components.PinholeProjection";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Mat3x3>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::PinholeProjection` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::PinholeProjection* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Mat3x3>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Mat3x3>::to_arrow(
                    &instances->image_from_camera,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
