// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/radius.fbs".

#pragma once

#include "../datatypes/float32.hpp"
#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: The radius of something, e.g. a point.
    ///
    /// Internally, positive values indicate scene units, whereas negative values
    /// are interpreted as UI points.
    ///
    /// UI points are independent of zooming in Views, but are sensitive to the application UI scaling.
    /// at 100% UI scaling, UI points are equal to pixels
    /// The Viewer's UI scaling defaults to the OS scaling which typically is 100% for full HD screens and 200% for 4k screens.
    struct Radius {
        rerun::datatypes::Float32 value;

      public: // START of extensions from radius_ext.cpp:
        /// Creates a new radius in scene units.
        ///
        /// Values passed must be finite positive.
        static Radius scene_units(float radius_in_scene_units) {
            return Radius(radius_in_scene_units);
        }

        /// Creates a new radius in ui points.
        ///
        /// Values passed must be finite positive.
        static Radius ui_points(float radius_in_ui_points) {
            return Radius(-radius_in_ui_points);
        }

        // END of extensions from radius_ext.cpp, start of generated code:

      public:
        Radius() = default;

        Radius(rerun::datatypes::Float32 value_) : value(value_) {}

        Radius& operator=(rerun::datatypes::Float32 value_) {
            value = value_;
            return *this;
        }

        Radius(float value_) : value(value_) {}

        Radius& operator=(float value_) {
            value = value_;
            return *this;
        }

        /// Cast to the underlying Float32 datatype
        operator rerun::datatypes::Float32() const {
            return value;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Float32) == sizeof(components::Radius));

    /// \private
    template <>
    struct Loggable<components::Radius> {
        static constexpr std::string_view ComponentType = "rerun.components.Radius";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Float32>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::Radius` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::Radius* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Float32>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Float32>::to_arrow(
                    &instances->value,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
