// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/transform_frame_id.fbs".

#pragma once

#include "../datatypes/utf8.hpp"
#include "../result.hpp"

#include <cstdint>
#include <memory>
#include <string>
#include <utility>

namespace rerun::components {
    /// **Component**: A string identifier for a transform frame.
    ///
    /// Transform frames may be derived from entity paths to refer to Rerun's implicit
    /// entity path driven hierarchy which is defined via `archetypes::Transform3D`, `archetypes::Pinhole` etc..
    /// These implicit transform frames look like `tf#path/to/entity`.
    ///
    /// Note that any `archetypes::Transform3D`s logged with both `parent_frame` and `child_frame` set
    /// describes a relationship between these parent and child transform frames, **not** the transform frame
    /// that the entity path may be using (defined by an `archetypes::CoordinateFrame`).
    struct TransformFrameId {
        rerun::datatypes::Utf8 value;

      public: // START of extensions from transform_frame_id_ext.cpp:
        TransformFrameId(std::string_view path_) : value(std::string(path_)) {}

        TransformFrameId(const char* path_) : value(std::string(path_)) {}

        // END of extensions from transform_frame_id_ext.cpp, start of generated code:

      public:
        TransformFrameId() = default;

        TransformFrameId(rerun::datatypes::Utf8 value_) : value(std::move(value_)) {}

        TransformFrameId& operator=(rerun::datatypes::Utf8 value_) {
            value = std::move(value_);
            return *this;
        }

        TransformFrameId(std::string value_) : value(std::move(value_)) {}

        TransformFrameId& operator=(std::string value_) {
            value = std::move(value_);
            return *this;
        }

        /// Cast to the underlying Utf8 datatype
        operator rerun::datatypes::Utf8() const {
            return value;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Utf8) == sizeof(components::TransformFrameId));

    /// \private
    template <>
    struct Loggable<components::TransformFrameId> {
        static constexpr std::string_view ComponentType = "rerun.components.TransformFrameId";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Utf8>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::TransformFrameId` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::TransformFrameId* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Utf8>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Utf8>::to_arrow(&instances->value, num_instances);
            }
        }
    };
} // namespace rerun
