// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/components/translation3d.fbs".

#pragma once

#include "../datatypes/vec3d.hpp"
#include "../result.hpp"

#include <array>
#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: A translation vector in 3D space.
    struct Translation3D {
        rerun::datatypes::Vec3D vector;

      public: // START of extensions from translation3d_ext.cpp:
        /// Construct `Translation3D` from x/y/z values.
        Translation3D(float x, float y, float z) : vector{x, y, z} {}

        /// Construct `Translation3D` from x/y/z float pointer.
        explicit Translation3D(const float* xyz) : vector{xyz[0], xyz[1], xyz[2]} {}

        float x() const {
            return vector.x();
        }

        float y() const {
            return vector.y();
        }

        float z() const {
            return vector.z();
        }

        // END of extensions from translation3d_ext.cpp, start of generated code:

      public:
        Translation3D() = default;

        Translation3D(rerun::datatypes::Vec3D vector_) : vector(vector_) {}

        Translation3D& operator=(rerun::datatypes::Vec3D vector_) {
            vector = vector_;
            return *this;
        }

        Translation3D(std::array<float, 3> xyz_) : vector(xyz_) {}

        Translation3D& operator=(std::array<float, 3> xyz_) {
            vector = xyz_;
            return *this;
        }

        /// Cast to the underlying Vec3D datatype
        operator rerun::datatypes::Vec3D() const {
            return vector;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Vec3D) == sizeof(components::Translation3D));

    /// \private
    template <>
    struct Loggable<components::Translation3D> {
        static constexpr std::string_view ComponentType = "rerun.components.Translation3D";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Vec3D>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::Translation3D` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::Translation3D* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Vec3D>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Vec3D>::to_arrow(
                    &instances->vector,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
