// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/datatypes/angle.fbs".

#pragma once

#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace arrow {
    /// \private
    template <typename T>
    class NumericBuilder;

    class Array;
    class DataType;
    class FloatType;
    using FloatBuilder = NumericBuilder<FloatType>;
} // namespace arrow

namespace rerun::datatypes {
    /// **Datatype**: Angle in radians.
    struct Angle {
        /// Angle in radians. One turn is equal to 2π (or τ) radians.
        float angle_radians;

      public: // START of extensions from angle_ext.cpp:
        /// New angle in radians.
        static Angle radians(float radians_) {
            Angle angle;
            angle.angle_radians = radians_;
            return angle;
        }

        /// New angle in degrees.
        ///
        /// Converts to radians to store the angle.
        static Angle degrees(float degrees_) {
            Angle angle;
            // Can't use math constants here: `M_PI` doesn't work on all platforms out of the box and std::numbers::pi is C++20.
            angle.angle_radians = degrees_ * (3.14159265358979323846264338327950288f / 180.f);
            return angle;
        }

        // END of extensions from angle_ext.cpp, start of generated code:

      public:
        Angle() = default;
    };
} // namespace rerun::datatypes

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<datatypes::Angle> {
        static constexpr std::string_view ComponentType = "rerun.datatypes.Angle";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::datatypes::Angle` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const datatypes::Angle* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::FloatBuilder* builder, const datatypes::Angle* elements, size_t num_elements
        );
    };
} // namespace rerun
