// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/datatypes/pixel_format.fbs".

#pragma once

#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace arrow {
    /// \private
    template <typename T>
    class NumericBuilder;

    class Array;
    class DataType;
    class UInt8Type;
    using UInt8Builder = NumericBuilder<UInt8Type>;
} // namespace arrow

namespace rerun::datatypes {
    /// **Datatype**: Specifieds a particular format of an `archetypes::Image`.
    ///
    /// Most images can be described by a `datatypes::ColorModel` and a `datatypes::ChannelDatatype`,
    /// e.g. `RGB` and `U8` respectively.
    ///
    /// However, some image formats has chroma downsampling and/or
    /// use differing number of bits per channel, and that is what this `datatypes::PixelFormat` is for.
    ///
    /// All these formats support random access.
    ///
    /// For more compressed image formats, see `archetypes::EncodedImage`.
    enum class PixelFormat : uint8_t {

        /// `Y_U_V12` is a YUV 4:2:0 fully planar YUV format without chroma downsampling, also known as `I420`.
        ///
        /// This uses limited range YUV, i.e. Y is expected to be within [16, 235] and U/V within [16, 240].
        ///
        /// First comes entire image in Y in one plane, followed by the U and V planes, which each only have half
        /// the resolution of the Y plane.
        Y_U_V12_LimitedRange = 20,

        /// `NV12` (aka `Y_UV12`) is a YUV 4:2:0 chroma downsampled form at with 12 bits per pixel and 8 bits per channel.
        ///
        /// This uses limited range YUV, i.e. Y is expected to be within [16, 235] and U/V within [16, 240].
        ///
        /// First comes entire image in Y in one plane,
        /// followed by a plane with interleaved lines ordered as U0, V0, U1, V1, etc.
        NV12 = 26,

        /// `YUY2` (aka 'YUYV', 'YUYV16' or 'NV21'), is a YUV 4:2:2 chroma downsampled format with 16 bits per pixel and 8 bits per channel.
        ///
        /// This uses limited range YUV, i.e. Y is expected to be within [16, 235] and U/V within [16, 240].
        ///
        /// The order of the channels is Y0, U0, Y1, V0, all in the same plane.
        YUY2 = 27,

        /// Monochrome Y plane only, essentially a YUV 4:0:0 planar format.
        ///
        /// Also known as just "gray". This is virtually identical to a 8bit luminance/grayscale (see `datatypes::ColorModel`).
        ///
        /// This uses entire range YUV, i.e. Y is expected to be within [0, 255].
        /// (as opposed to "limited range" YUV as used e.g. in NV12).
        Y8_FullRange = 30,

        /// `Y_U_V24` is a YUV 4:4:4 fully planar YUV format without chroma downsampling, also known as `I444`.
        ///
        /// This uses limited range YUV, i.e. Y is expected to be within [16, 235] and U/V within [16, 240].
        ///
        /// First comes entire image in Y in one plane, followed by the U and V planes.
        Y_U_V24_LimitedRange = 39,

        /// `Y_U_V24` is a YUV 4:4:4 fully planar YUV format without chroma downsampling, also known as `I444`.
        ///
        /// This uses full range YUV with all components ranging from 0 to 255
        /// (as opposed to "limited range" YUV as used e.g. in NV12).
        ///
        /// First comes entire image in Y in one plane, followed by the U and V planes.
        Y_U_V24_FullRange = 40,

        /// Monochrome Y plane only, essentially a YUV 4:0:0 planar format.
        ///
        /// Also known as just "gray".
        ///
        /// This uses limited range YUV, i.e. Y is expected to be within [16, 235].
        /// If not for this range limitation/remapping, this is almost identical to 8bit luminace/grayscale (see `datatypes::ColorModel`).
        Y8_LimitedRange = 41,

        /// `Y_U_V12` is a YUV 4:2:0 fully planar YUV format without chroma downsampling, also known as `I420`.
        ///
        /// This uses full range YUV with all components ranging from 0 to 255
        /// (as opposed to "limited range" YUV as used e.g. in NV12).
        ///
        /// First comes entire image in Y in one plane, followed by the U and V planes, which each only have half
        /// the resolution of the Y plane.
        Y_U_V12_FullRange = 44,

        /// `Y_U_V16` is a YUV 4:2:2 fully planar YUV format without chroma downsampling, also known as `I422`.
        ///
        /// This uses limited range YUV, i.e. Y is expected to be within [16, 235] and U/V within [16, 240].
        ///
        /// First comes entire image in Y in one plane, followed by the U and V planes, which each only have half
        /// the horizontal resolution of the Y plane.
        Y_U_V16_LimitedRange = 49,

        /// `Y_U_V16` is a YUV 4:2:2 fully planar YUV format without chroma downsampling, also known as `I422`.
        ///
        /// This uses full range YUV with all components ranging from 0 to 255
        /// (as opposed to "limited range" YUV as used e.g. in NV12).
        ///
        /// First comes entire image in Y in one plane, followed by the U and V planes, which each only have half
        /// the horizontal resolution of the Y plane.
        Y_U_V16_FullRange = 50,
    };
} // namespace rerun::datatypes

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<datatypes::PixelFormat> {
        static constexpr std::string_view ComponentType = "rerun.datatypes.PixelFormat";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::datatypes::PixelFormat` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const datatypes::PixelFormat* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::UInt8Builder* builder, const datatypes::PixelFormat* elements,
            size_t num_elements
        );
    };
} // namespace rerun
