// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_sdk_types/definitions/rerun/datatypes/tensor_data.fbs".

#pragma once

#include "../collection.hpp"
#include "../result.hpp"
#include "tensor_buffer.hpp"

#include <cstdint>
#include <memory>
#include <optional>
#include <string>

namespace arrow {
    class Array;
    class DataType;
    class StructBuilder;
} // namespace arrow

namespace rerun::datatypes {
    /// **Datatype**: An N-dimensional array of numbers.
    ///
    /// The number of dimensions and their respective lengths is specified by the `shape` field.
    /// The dimensions are ordered from outermost to innermost. For example, in the common case of
    /// a 2D RGB Image, the shape would be `[height, width, channel]`.
    ///
    /// These dimensions are combined with an index to look up values from the `buffer` field,
    /// which stores a contiguous array of typed values.
    struct TensorData {
        /// The shape of the tensor, i.e. the length of each dimension.
        rerun::Collection<uint64_t> shape;

        /// The names of the dimensions of the tensor (optional).
        ///
        /// If set, should be the same length as `datatypes::TensorData::shape`.
        /// If it has a different length your names may show up improperly,
        /// and some constructors may produce a warning or even an error.
        ///
        /// Example: `["height", "width", "channel", "batch"]`.
        std::optional<rerun::Collection<std::string>> names;

        /// The content/data.
        rerun::datatypes::TensorBuffer buffer;

      public: // START of extensions from tensor_data_ext.cpp:
        /// New tensor data from shape and tensor buffer.
        ///
        /// \param shape_ Shape of the tensor.
        /// \param buffer_ The tensor buffer containing the tensor's data.
        TensorData(Collection<uint64_t> shape_, datatypes::TensorBuffer buffer_)
            : shape(std::move(shape_)), buffer(std::move(buffer_)) {}

        /// New tensor data from dimensions and pointer to tensor data.
        ///
        /// Type must be one of the types supported by `rerun::datatypes::TensorData`.
        /// \param shape_ Shape of the tensor. Determines the number of elements expected to be in `data`.
        /// \param data Target of the pointer must outlive the archetype.
        template <typename TElement>
        explicit TensorData(Collection<uint64_t> shape_, const TElement* data)
            : shape(std::move(shape_)) {
            size_t num_elements = shape.empty() ? 0 : 1;
            for (const auto& dim : shape) {
                num_elements *= dim;
            }
            buffer = rerun::Collection<TElement>::borrow(data, num_elements);
        }

        // END of extensions from tensor_data_ext.cpp, start of generated code:

      public:
        TensorData() = default;
    };
} // namespace rerun::datatypes

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<datatypes::TensorData> {
        static constexpr std::string_view ComponentType = "rerun.datatypes.TensorData";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::datatypes::TensorData` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const datatypes::TensorData* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::StructBuilder* builder, const datatypes::TensorData* elements,
            size_t num_elements
        );
    };
} // namespace rerun
