// DO NOT EDIT! This file was auto-generated by crates/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/re_types/definitions/rerun/archetypes/series_line.fbs".

#pragma once

#include "../collection.hpp"
#include "../compiler_utils.hpp"
#include "../components/color.hpp"
#include "../components/name.hpp"
#include "../components/stroke_width.hpp"
#include "../data_cell.hpp"
#include "../indicator_component.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: Define the style properties for a line series in a chart.
    ///
    /// This archetype only provides styling information and should be logged as static
    /// when possible. The underlying data needs to be logged to the same entity-path using
    /// the `Scalar` archetype.
    ///
    /// See `rerun::archetypes::Scalar`
    ///
    /// ## Example
    ///
    /// ### Line series
    /// ![image](https://static.rerun.io/series_line_style/d2616d98b1e46bdb85849b8669154fdf058e3453/full.png)
    ///
    /// ```cpp
    /// #include <rerun.hpp>
    ///
    /// #include <cmath>
    ///
    /// constexpr float TAU = 6.28318530717958647692528676655900577f;
    ///
    /// int main() {
    ///     const auto rec = rerun::RecordingStream("rerun_example_series_line_style");
    ///     rec.spawn().exit_on_failure();
    ///
    ///     // Set up plot styling:
    ///     // They are logged static as they don't change over time and apply to all timelines.
    ///     // Log two lines series under a shared root so that they show in the same plot by default.
    ///     rec.log_static(
    ///         "trig/sin",
    ///         rerun::SeriesLine().with_color({255, 0, 0}).with_name("sin(0.01t)").with_width(2)
    ///     );
    ///     rec.log_static(
    ///         "trig/cos",
    ///         rerun::SeriesLine().with_color({0, 255, 0}).with_name("cos(0.01t)").with_width(4)
    ///     );
    ///
    ///     // Log the data on a timeline called "step".
    ///     for (int t = 0; t <static_cast<int>(TAU * 2.0 * 100.0); ++t) {
    ///         rec.set_time_sequence("step", t);
    ///
    ///         rec.log("trig/sin", rerun::Scalar(sin(static_cast<double>(t) / 100.0)));
    ///         rec.log("trig/cos", rerun::Scalar(cos(static_cast<double>(t) / 100.0f)));
    ///     }
    /// }
    /// ```
    struct SeriesLine {
        /// Color for the corresponding series.
        std::optional<rerun::components::Color> color;

        /// Stroke width for the corresponding series.
        std::optional<rerun::components::StrokeWidth> width;

        /// Display name of the series.
        ///
        /// Used in the legend.
        std::optional<rerun::components::Name> name;

      public:
        static constexpr const char IndicatorComponentName[] =
            "rerun.components.SeriesLineIndicator";

        /// Indicator component, used to identify the archetype when converting to a list of components.
        using IndicatorComponent = rerun::components::IndicatorComponent<IndicatorComponentName>;

      public:
        SeriesLine() = default;
        SeriesLine(SeriesLine&& other) = default;

        /// Color for the corresponding series.
        SeriesLine with_color(rerun::components::Color _color) && {
            color = std::move(_color);
            // See: https://github.com/rerun-io/rerun/issues/4027
            RR_WITH_MAYBE_UNINITIALIZED_DISABLED(return std::move(*this);)
        }

        /// Stroke width for the corresponding series.
        SeriesLine with_width(rerun::components::StrokeWidth _width) && {
            width = std::move(_width);
            // See: https://github.com/rerun-io/rerun/issues/4027
            RR_WITH_MAYBE_UNINITIALIZED_DISABLED(return std::move(*this);)
        }

        /// Display name of the series.
        ///
        /// Used in the legend.
        SeriesLine with_name(rerun::components::Name _name) && {
            name = std::move(_name);
            // See: https://github.com/rerun-io/rerun/issues/4027
            RR_WITH_MAYBE_UNINITIALIZED_DISABLED(return std::move(*this);)
        }
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::SeriesLine> {
        /// Serialize all set component batches.
        static Result<std::vector<DataCell>> serialize(const archetypes::SeriesLine& archetype);
    };
} // namespace rerun
