// DO NOT EDIT! This file was auto-generated by crates/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/re_types/definitions/rerun/blueprint/archetypes/space_view_blueprint.fbs".

#pragma once

#include "../../blueprint/components/space_view_class.hpp"
#include "../../blueprint/components/space_view_origin.hpp"
#include "../../blueprint/components/visible.hpp"
#include "../../collection.hpp"
#include "../../compiler_utils.hpp"
#include "../../components/name.hpp"
#include "../../data_cell.hpp"
#include "../../indicator_component.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: The top-level description of the Viewport.
    struct SpaceViewBlueprint {
        /// The class of the view.
        rerun::blueprint::components::SpaceViewClass class_identifier;

        /// The name of the view.
        std::optional<rerun::components::Name> display_name;

        /// The "anchor point" of this space view.
        ///
        /// Defaults to the root path '/' if not specified.
        ///
        /// The transform at this path forms the reference point for all scene->world transforms in this space view.
        /// I.e. the position of this entity path in space forms the origin of the coordinate system in this space view.
        /// Furthermore, this is the primary indicator for heuristics on what entities we show in this space view.
        std::optional<rerun::blueprint::components::SpaceViewOrigin> space_origin;

        /// Whether this space view is visible.
        ///
        /// Defaults to true if not specified.
        std::optional<rerun::blueprint::components::Visible> visible;

      public:
        static constexpr const char IndicatorComponentName[] =
            "rerun.blueprint.components.SpaceViewBlueprintIndicator";

        /// Indicator component, used to identify the archetype when converting to a list of components.
        using IndicatorComponent = rerun::components::IndicatorComponent<IndicatorComponentName>;

      public:
        SpaceViewBlueprint() = default;
        SpaceViewBlueprint(SpaceViewBlueprint&& other) = default;

        explicit SpaceViewBlueprint(rerun::blueprint::components::SpaceViewClass _class_identifier)
            : class_identifier(std::move(_class_identifier)) {}

        /// The name of the view.
        SpaceViewBlueprint with_display_name(rerun::components::Name _display_name) && {
            display_name = std::move(_display_name);
            // See: https://github.com/rerun-io/rerun/issues/4027
            RR_WITH_MAYBE_UNINITIALIZED_DISABLED(return std::move(*this);)
        }

        /// The "anchor point" of this space view.
        ///
        /// Defaults to the root path '/' if not specified.
        ///
        /// The transform at this path forms the reference point for all scene->world transforms in this space view.
        /// I.e. the position of this entity path in space forms the origin of the coordinate system in this space view.
        /// Furthermore, this is the primary indicator for heuristics on what entities we show in this space view.
        SpaceViewBlueprint with_space_origin(
            rerun::blueprint::components::SpaceViewOrigin _space_origin
        ) && {
            space_origin = std::move(_space_origin);
            // See: https://github.com/rerun-io/rerun/issues/4027
            RR_WITH_MAYBE_UNINITIALIZED_DISABLED(return std::move(*this);)
        }

        /// Whether this space view is visible.
        ///
        /// Defaults to true if not specified.
        SpaceViewBlueprint with_visible(rerun::blueprint::components::Visible _visible) && {
            visible = std::move(_visible);
            // See: https://github.com/rerun-io/rerun/issues/4027
            RR_WITH_MAYBE_UNINITIALIZED_DISABLED(return std::move(*this);)
        }
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::SpaceViewBlueprint> {
        /// Serialize all set component batches.
        static Result<std::vector<DataCell>> serialize(
            const blueprint::archetypes::SpaceViewBlueprint& archetype
        );
    };
} // namespace rerun
