// DO NOT EDIT! This file was auto-generated by crates/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/re_types/definitions/rerun/components/disconnected_space.fbs".

#pragma once

#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace arrow {
    class Array;
    class BooleanBuilder;
    class DataType;
} // namespace arrow

namespace rerun::components {
    /// **Component**: Spatially disconnect this entity from its parent.
    ///
    /// Specifies that the entity path at which this is logged is spatially disconnected from its parent,
    /// making it impossible to transform the entity path into its parent's space and vice versa.
    /// It *only* applies to space views that work with spatial transformations, i.e. 2D & 3D space views.
    /// This is useful for specifying that a subgraph is independent of the rest of the scene.
    struct DisconnectedSpace {
        /// Whether the entity path at which this is logged is disconnected from its parent.
        ///
        /// Set to true to disconnect the entity from its parent.
        /// Set to false to disable the effects of this component, (re-)connecting the entity to its parent again.
        bool is_disconnected;

      public:
        DisconnectedSpace() = default;

        DisconnectedSpace(bool is_disconnected_) : is_disconnected(is_disconnected_) {}

        DisconnectedSpace& operator=(bool is_disconnected_) {
            is_disconnected = is_disconnected_;
            return *this;
        }
    };
} // namespace rerun::components

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<components::DisconnectedSpace> {
        static constexpr const char Name[] = "rerun.components.DisconnectedSpace";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::components::DisconnectedSpace` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::DisconnectedSpace* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::BooleanBuilder* builder, const components::DisconnectedSpace* elements,
            size_t num_elements
        );
    };
} // namespace rerun
