// DO NOT EDIT! This file was auto-generated by crates/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/re_types/definitions/rerun/datatypes/angle.fbs".

#pragma once

#include "../result.hpp"

#include <cstdint>
#include <cstring>
#include <memory>
#include <new>
#include <utility>

namespace arrow {
    class Array;
    class DataType;
    class DenseUnionBuilder;
} // namespace arrow

namespace rerun::datatypes {
    namespace detail {
        /// \private
        enum class AngleTag : uint8_t {
            /// Having a special empty state makes it possible to implement move-semantics. We need to be able to leave the object in a state which we can run the destructor on.
            None = 0,
            Radians,
            Degrees,
        };

        /// \private
        union AngleData {
            /// Angle in radians. One turn is equal to 2π (or τ) radians.
            float radians;

            /// Angle in degrees. One turn is equal to 360 degrees.
            float degrees;

            AngleData() {
                std::memset(reinterpret_cast<void*>(this), 0, sizeof(AngleData));
            }

            ~AngleData() {}

            void swap(AngleData& other) noexcept {
                // This bitwise swap would fail for self-referential types, but we don't have any of those.
                char temp[sizeof(AngleData)];
                void* otherbytes = reinterpret_cast<void*>(&other);
                void* thisbytes = reinterpret_cast<void*>(this);
                std::memcpy(temp, thisbytes, sizeof(AngleData));
                std::memcpy(thisbytes, otherbytes, sizeof(AngleData));
                std::memcpy(otherbytes, temp, sizeof(AngleData));
            }
        };
    } // namespace detail

    /// **Datatype**: Angle in either radians or degrees.
    struct Angle {
        Angle() : _tag(detail::AngleTag::None) {}

        /// Copy constructor
        Angle(const Angle& other) : _tag(other._tag) {
            const void* otherbytes = reinterpret_cast<const void*>(&other._data);
            void* thisbytes = reinterpret_cast<void*>(&this->_data);
            std::memcpy(thisbytes, otherbytes, sizeof(detail::AngleData));
        }

        Angle& operator=(const Angle& other) noexcept {
            Angle tmp(other);
            this->swap(tmp);
            return *this;
        }

        Angle(Angle&& other) noexcept : Angle() {
            this->swap(other);
        }

        Angle& operator=(Angle&& other) noexcept {
            this->swap(other);
            return *this;
        }

        void swap(Angle& other) noexcept {
            std::swap(this->_tag, other._tag);
            this->_data.swap(other._data);
        }

        /// Angle in radians. One turn is equal to 2π (or τ) radians.
        static Angle radians(float radians) {
            Angle self;
            self._tag = detail::AngleTag::Radians;
            new (&self._data.radians) float(std::move(radians));
            return self;
        }

        /// Angle in degrees. One turn is equal to 360 degrees.
        static Angle degrees(float degrees) {
            Angle self;
            self._tag = detail::AngleTag::Degrees;
            new (&self._data.degrees) float(std::move(degrees));
            return self;
        }

        /// Return a pointer to radians if the union is in that state, otherwise `nullptr`.
        const float* get_radians() const {
            if (_tag == detail::AngleTag::Radians) {
                return &_data.radians;
            } else {
                return nullptr;
            }
        }

        /// Return a pointer to degrees if the union is in that state, otherwise `nullptr`.
        const float* get_degrees() const {
            if (_tag == detail::AngleTag::Degrees) {
                return &_data.degrees;
            } else {
                return nullptr;
            }
        }

        /// \private
        const detail::AngleData& get_union_data() const {
            return _data;
        }

        /// \private
        detail::AngleTag get_union_tag() const {
            return _tag;
        }

      private:
        detail::AngleTag _tag;
        detail::AngleData _data;
    };
} // namespace rerun::datatypes

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<datatypes::Angle> {
        static constexpr const char Name[] = "rerun.datatypes.Angle";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::datatypes::Angle` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const datatypes::Angle* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::DenseUnionBuilder* builder, const datatypes::Angle* elements, size_t num_elements
        );
    };
} // namespace rerun
