// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/cylinders3d.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/class_id.hpp"
#include "../components/color.hpp"
#include "../components/fill_mode.hpp"
#include "../components/length.hpp"
#include "../components/pose_rotation_axis_angle.hpp"
#include "../components/pose_rotation_quat.hpp"
#include "../components/pose_translation3d.hpp"
#include "../components/radius.hpp"
#include "../components/show_labels.hpp"
#include "../components/text.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: 3D cylinders with flat caps.
    ///
    /// This archetype is for cylinder primitives defined by their axial length and radius.
    /// For points whose radii are for visualization purposes, use `archetypes::Points3D` instead.
    ///
    /// Orienting and placing cylinders forms a separate transform that is applied prior to `archetypes::InstancePoses3D` and `archetypes::Transform3D`.
    ///
    /// ## Example
    ///
    /// ### Batch of cylinders
    /// ![image](https://static.rerun.io/cylinders3d_batch/ef642dede2bef23704eaff0f22aa48284d482b23/full.png)
    ///
    /// ```cpp
    /// #include <rerun.hpp>
    ///
    /// int main() {
    ///     const auto rec = rerun::RecordingStream("rerun_example_cylinders3d_batch");
    ///     rec.spawn().exit_on_failure();
    ///
    ///     rec.log(
    ///         "cylinders",
    ///         rerun::Cylinders3D::from_lengths_and_radii(
    ///             {0.0f, 2.0f, 4.0f, 6.0f, 8.0f},
    ///             {1.0f, 0.5f, 0.5f, 0.5f, 1.0f}
    ///         )
    ///             .with_colors({
    ///                 rerun::Rgba32(255, 0, 0),
    ///                 rerun::Rgba32(188, 188, 0),
    ///                 rerun::Rgba32(0, 255, 0),
    ///                 rerun::Rgba32(0, 188, 188),
    ///                 rerun::Rgba32(0, 0, 255),
    ///             })
    ///             .with_centers({
    ///                 {0.0f, 0.0f, 0.0f},
    ///                 {2.0f, 0.0f, 0.0f},
    ///                 {4.0f, 0.0f, 0.0f},
    ///                 {6.0f, 0.0f, 0.0f},
    ///                 {8.0f, 0.0f, 0.0f},
    ///             })
    ///             .with_rotation_axis_angles({
    ///                 rerun::RotationAxisAngle({1.0f, 0.0f, 0.0f}, rerun::Angle::degrees(0.0)),
    ///                 rerun::RotationAxisAngle({1.0f, 0.0f, 0.0f}, rerun::Angle::degrees(-22.5)),
    ///                 rerun::RotationAxisAngle({1.0f, 0.0f, 0.0f}, rerun::Angle::degrees(-45.0)),
    ///                 rerun::RotationAxisAngle({1.0f, 0.0f, 0.0f}, rerun::Angle::degrees(-67.5)),
    ///                 rerun::RotationAxisAngle({1.0f, 0.0f, 0.0f}, rerun::Angle::degrees(-90.0)),
    ///             })
    ///     );
    /// }
    /// ```
    struct Cylinders3D {
        /// The total axial length of the cylinder, measured as the straight-line distance between the centers of its two endcaps.
        std::optional<ComponentBatch> lengths;

        /// Radii of the cylinders.
        std::optional<ComponentBatch> radii;

        /// Optional centers of the cylinders.
        ///
        /// If not specified, each cylinder will be centered at (0, 0, 0).
        std::optional<ComponentBatch> centers;

        /// Rotations via axis + angle.
        ///
        /// If no rotation is specified, the cylinders align with the +Z axis of the local coordinate system.
        std::optional<ComponentBatch> rotation_axis_angles;

        /// Rotations via quaternion.
        ///
        /// If no rotation is specified, the cylinders align with the +Z axis of the local coordinate system.
        std::optional<ComponentBatch> quaternions;

        /// Optional colors for the cylinders.
        ///
        /// Alpha channel is used for transparency for solid fill-mode.
        std::optional<ComponentBatch> colors;

        /// Optional radii for the lines used when the cylinder is rendered as a wireframe.
        std::optional<ComponentBatch> line_radii;

        /// Optionally choose whether the cylinders are drawn with lines or solid.
        std::optional<ComponentBatch> fill_mode;

        /// Optional text labels for the cylinders, which will be located at their centers.
        std::optional<ComponentBatch> labels;

        /// Whether the text labels should be shown.
        ///
        /// If not set, labels will automatically appear when there is exactly one label for this entity
        /// or the number of instances on this entity is under a certain threshold.
        std::optional<ComponentBatch> show_labels;

        /// Optional class ID for the ellipsoids.
        ///
        /// The class ID provides colors and labels if not specified explicitly.
        std::optional<ComponentBatch> class_ids;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.Cylinders3D";

        /// `ComponentDescriptor` for the `lengths` field.
        static constexpr auto Descriptor_lengths = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:lengths", Loggable<rerun::components::Length>::ComponentType
        );
        /// `ComponentDescriptor` for the `radii` field.
        static constexpr auto Descriptor_radii = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:radii", Loggable<rerun::components::Radius>::ComponentType
        );
        /// `ComponentDescriptor` for the `centers` field.
        static constexpr auto Descriptor_centers = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:centers",
            Loggable<rerun::components::PoseTranslation3D>::ComponentType
        );
        /// `ComponentDescriptor` for the `rotation_axis_angles` field.
        static constexpr auto Descriptor_rotation_axis_angles = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:rotation_axis_angles",
            Loggable<rerun::components::PoseRotationAxisAngle>::ComponentType
        );
        /// `ComponentDescriptor` for the `quaternions` field.
        static constexpr auto Descriptor_quaternions = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:quaternions",
            Loggable<rerun::components::PoseRotationQuat>::ComponentType
        );
        /// `ComponentDescriptor` for the `colors` field.
        static constexpr auto Descriptor_colors = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:colors", Loggable<rerun::components::Color>::ComponentType
        );
        /// `ComponentDescriptor` for the `line_radii` field.
        static constexpr auto Descriptor_line_radii = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:line_radii",
            Loggable<rerun::components::Radius>::ComponentType
        );
        /// `ComponentDescriptor` for the `fill_mode` field.
        static constexpr auto Descriptor_fill_mode = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:fill_mode",
            Loggable<rerun::components::FillMode>::ComponentType
        );
        /// `ComponentDescriptor` for the `labels` field.
        static constexpr auto Descriptor_labels = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:labels", Loggable<rerun::components::Text>::ComponentType
        );
        /// `ComponentDescriptor` for the `show_labels` field.
        static constexpr auto Descriptor_show_labels = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:show_labels",
            Loggable<rerun::components::ShowLabels>::ComponentType
        );
        /// `ComponentDescriptor` for the `class_ids` field.
        static constexpr auto Descriptor_class_ids = ComponentDescriptor(
            ArchetypeName, "Cylinders3D:class_ids",
            Loggable<rerun::components::ClassId>::ComponentType
        );

      public: // START of extensions from cylinders3d_ext.cpp:
        /// Creates a new `Cylinders3D` with the given axis-aligned lengths and radii.
        ///
        /// For multiple cylinders, you should generally follow this with
        /// `Cylinders3D::with_centers()` and one of the rotation methods, in order to move them
        /// apart from each other.
        static Cylinders3D from_lengths_and_radii(
            const Collection<rerun::components::Length>& lengths,
            const Collection<rerun::components::Radius>& radii
        ) {
            return Cylinders3D().with_lengths(lengths).with_radii(radii);
        }

        // END of extensions from cylinders3d_ext.cpp, start of generated code:

      public:
        Cylinders3D() = default;
        Cylinders3D(Cylinders3D&& other) = default;
        Cylinders3D(const Cylinders3D& other) = default;
        Cylinders3D& operator=(const Cylinders3D& other) = default;
        Cylinders3D& operator=(Cylinders3D&& other) = default;

        /// Update only some specific fields of a `Cylinders3D`.
        static Cylinders3D update_fields() {
            return Cylinders3D();
        }

        /// Clear all the fields of a `Cylinders3D`.
        static Cylinders3D clear_fields();

        /// The total axial length of the cylinder, measured as the straight-line distance between the centers of its two endcaps.
        Cylinders3D with_lengths(const Collection<rerun::components::Length>& _lengths) && {
            lengths = ComponentBatch::from_loggable(_lengths, Descriptor_lengths).value_or_throw();
            return std::move(*this);
        }

        /// Radii of the cylinders.
        Cylinders3D with_radii(const Collection<rerun::components::Radius>& _radii) && {
            radii = ComponentBatch::from_loggable(_radii, Descriptor_radii).value_or_throw();
            return std::move(*this);
        }

        /// Optional centers of the cylinders.
        ///
        /// If not specified, each cylinder will be centered at (0, 0, 0).
        Cylinders3D with_centers(const Collection<rerun::components::PoseTranslation3D>& _centers
        ) && {
            centers = ComponentBatch::from_loggable(_centers, Descriptor_centers).value_or_throw();
            return std::move(*this);
        }

        /// Rotations via axis + angle.
        ///
        /// If no rotation is specified, the cylinders align with the +Z axis of the local coordinate system.
        Cylinders3D with_rotation_axis_angles(
            const Collection<rerun::components::PoseRotationAxisAngle>& _rotation_axis_angles
        ) && {
            rotation_axis_angles = ComponentBatch::from_loggable(
                                       _rotation_axis_angles,
                                       Descriptor_rotation_axis_angles
            )
                                       .value_or_throw();
            return std::move(*this);
        }

        /// Rotations via quaternion.
        ///
        /// If no rotation is specified, the cylinders align with the +Z axis of the local coordinate system.
        Cylinders3D with_quaternions(
            const Collection<rerun::components::PoseRotationQuat>& _quaternions
        ) && {
            quaternions = ComponentBatch::from_loggable(_quaternions, Descriptor_quaternions)
                              .value_or_throw();
            return std::move(*this);
        }

        /// Optional colors for the cylinders.
        ///
        /// Alpha channel is used for transparency for solid fill-mode.
        Cylinders3D with_colors(const Collection<rerun::components::Color>& _colors) && {
            colors = ComponentBatch::from_loggable(_colors, Descriptor_colors).value_or_throw();
            return std::move(*this);
        }

        /// Optional radii for the lines used when the cylinder is rendered as a wireframe.
        Cylinders3D with_line_radii(const Collection<rerun::components::Radius>& _line_radii) && {
            line_radii =
                ComponentBatch::from_loggable(_line_radii, Descriptor_line_radii).value_or_throw();
            return std::move(*this);
        }

        /// Optionally choose whether the cylinders are drawn with lines or solid.
        Cylinders3D with_fill_mode(const rerun::components::FillMode& _fill_mode) && {
            fill_mode =
                ComponentBatch::from_loggable(_fill_mode, Descriptor_fill_mode).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `fill_mode` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_fill_mode` should
        /// be used when logging a single row's worth of data.
        Cylinders3D with_many_fill_mode(const Collection<rerun::components::FillMode>& _fill_mode
        ) && {
            fill_mode =
                ComponentBatch::from_loggable(_fill_mode, Descriptor_fill_mode).value_or_throw();
            return std::move(*this);
        }

        /// Optional text labels for the cylinders, which will be located at their centers.
        Cylinders3D with_labels(const Collection<rerun::components::Text>& _labels) && {
            labels = ComponentBatch::from_loggable(_labels, Descriptor_labels).value_or_throw();
            return std::move(*this);
        }

        /// Whether the text labels should be shown.
        ///
        /// If not set, labels will automatically appear when there is exactly one label for this entity
        /// or the number of instances on this entity is under a certain threshold.
        Cylinders3D with_show_labels(const rerun::components::ShowLabels& _show_labels) && {
            show_labels = ComponentBatch::from_loggable(_show_labels, Descriptor_show_labels)
                              .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `show_labels` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_show_labels` should
        /// be used when logging a single row's worth of data.
        Cylinders3D with_many_show_labels(
            const Collection<rerun::components::ShowLabels>& _show_labels
        ) && {
            show_labels = ComponentBatch::from_loggable(_show_labels, Descriptor_show_labels)
                              .value_or_throw();
            return std::move(*this);
        }

        /// Optional class ID for the ellipsoids.
        ///
        /// The class ID provides colors and labels if not specified explicitly.
        Cylinders3D with_class_ids(const Collection<rerun::components::ClassId>& _class_ids) && {
            class_ids =
                ComponentBatch::from_loggable(_class_ids, Descriptor_class_ids).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::Cylinders3D> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::Cylinders3D& archetype
        );
    };
} // namespace rerun
