// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/blueprint/archetypes/force_link.fbs".

#pragma once

#include "../../blueprint/components/enabled.hpp"
#include "../../blueprint/components/force_distance.hpp"
#include "../../blueprint/components/force_iterations.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Aims to achieve a target distance between two nodes that are connected by an edge.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct ForceLink {
        /// Whether the link force is enabled.
        ///
        /// The link force aims to achieve a target distance between two nodes that are connected by one ore more edges.
        std::optional<ComponentBatch> enabled;

        /// The target distance between two nodes.
        std::optional<ComponentBatch> distance;

        /// Specifies how often this force should be applied per iteration.
        ///
        /// Increasing this parameter can lead to better results at the cost of longer computation time.
        std::optional<ComponentBatch> iterations;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.ForceLink";

        /// `ComponentDescriptor` for the `enabled` field.
        static constexpr auto Descriptor_enabled = ComponentDescriptor(
            ArchetypeName, "ForceLink:enabled",
            Loggable<rerun::blueprint::components::Enabled>::ComponentType
        );
        /// `ComponentDescriptor` for the `distance` field.
        static constexpr auto Descriptor_distance = ComponentDescriptor(
            ArchetypeName, "ForceLink:distance",
            Loggable<rerun::blueprint::components::ForceDistance>::ComponentType
        );
        /// `ComponentDescriptor` for the `iterations` field.
        static constexpr auto Descriptor_iterations = ComponentDescriptor(
            ArchetypeName, "ForceLink:iterations",
            Loggable<rerun::blueprint::components::ForceIterations>::ComponentType
        );

      public:
        ForceLink() = default;
        ForceLink(ForceLink&& other) = default;
        ForceLink(const ForceLink& other) = default;
        ForceLink& operator=(const ForceLink& other) = default;
        ForceLink& operator=(ForceLink&& other) = default;

        /// Update only some specific fields of a `ForceLink`.
        static ForceLink update_fields() {
            return ForceLink();
        }

        /// Clear all the fields of a `ForceLink`.
        static ForceLink clear_fields();

        /// Whether the link force is enabled.
        ///
        /// The link force aims to achieve a target distance between two nodes that are connected by one ore more edges.
        ForceLink with_enabled(const rerun::blueprint::components::Enabled& _enabled) && {
            enabled = ComponentBatch::from_loggable(_enabled, Descriptor_enabled).value_or_throw();
            return std::move(*this);
        }

        /// The target distance between two nodes.
        ForceLink with_distance(const rerun::blueprint::components::ForceDistance& _distance) && {
            distance =
                ComponentBatch::from_loggable(_distance, Descriptor_distance).value_or_throw();
            return std::move(*this);
        }

        /// Specifies how often this force should be applied per iteration.
        ///
        /// Increasing this parameter can lead to better results at the cost of longer computation time.
        ForceLink with_iterations(const rerun::blueprint::components::ForceIterations& _iterations
        ) && {
            iterations =
                ComponentBatch::from_loggable(_iterations, Descriptor_iterations).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::ForceLink> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::ForceLink& archetype
        );
    };
} // namespace rerun
