// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/components/count.fbs".

#pragma once

#include "../datatypes/uint64.hpp"
#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: A generic count value.
    ///
    /// Used for counting various entities like messages, schemas, channels, etc.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct Count {
        rerun::datatypes::UInt64 value;

      public:
        Count() = default;

        Count(rerun::datatypes::UInt64 value_) : value(value_) {}

        Count& operator=(rerun::datatypes::UInt64 value_) {
            value = value_;
            return *this;
        }

        Count(uint64_t value_) : value(value_) {}

        Count& operator=(uint64_t value_) {
            value = value_;
            return *this;
        }

        /// Cast to the underlying UInt64 datatype
        operator rerun::datatypes::UInt64() const {
            return value;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::UInt64) == sizeof(components::Count));

    /// \private
    template <>
    struct Loggable<components::Count> {
        static constexpr std::string_view ComponentType = "rerun.components.Count";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::UInt64>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::Count` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::Count* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::UInt64>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::UInt64>::to_arrow(
                    &instances->value,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
