// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/geo_points.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/class_id.hpp"
#include "../components/color.hpp"
#include "../components/lat_lon.hpp"
#include "../components/radius.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: Geospatial points with positions expressed in [EPSG:4326](https://epsg.io/4326) latitude and longitude (North/East-positive degrees), and optional colors and radii.
    ///
    /// ## Example
    ///
    /// ### Log a geospatial point
    /// ![image](https://static.rerun.io/geopoint_simple/b86ce83e5871837587bd33a0ad639358b96e9010/full.png)
    ///
    /// ```cpp
    /// #include <rerun.hpp>
    ///
    /// int main() {
    ///     const auto rec = rerun::RecordingStream("rerun_example_geo_points");
    ///     rec.spawn().exit_on_failure();
    ///
    ///     rec.log(
    ///         "rerun_hq",
    ///         rerun::GeoPoints::from_lat_lon({{59.319221, 18.075631}})
    ///             .with_radii(rerun::Radius::ui_points(10.0f))
    ///             .with_colors(rerun::Color(255, 0, 0))
    ///     );
    /// }
    /// ```
    struct GeoPoints {
        /// The [EPSG:4326](https://epsg.io/4326) coordinates for the points (North/East-positive degrees).
        std::optional<ComponentBatch> positions;

        /// Optional radii for the points, effectively turning them into circles.
        ///
        /// *Note*: scene units radiii are interpreted as meters.
        std::optional<ComponentBatch> radii;

        /// Optional colors for the points.
        std::optional<ComponentBatch> colors;

        /// Optional class Ids for the points.
        ///
        /// The `components::ClassId` provides colors if not specified explicitly.
        std::optional<ComponentBatch> class_ids;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.GeoPoints";

        /// `ComponentDescriptor` for the `positions` field.
        static constexpr auto Descriptor_positions = ComponentDescriptor(
            ArchetypeName, "GeoPoints:positions", Loggable<rerun::components::LatLon>::ComponentType
        );
        /// `ComponentDescriptor` for the `radii` field.
        static constexpr auto Descriptor_radii = ComponentDescriptor(
            ArchetypeName, "GeoPoints:radii", Loggable<rerun::components::Radius>::ComponentType
        );
        /// `ComponentDescriptor` for the `colors` field.
        static constexpr auto Descriptor_colors = ComponentDescriptor(
            ArchetypeName, "GeoPoints:colors", Loggable<rerun::components::Color>::ComponentType
        );
        /// `ComponentDescriptor` for the `class_ids` field.
        static constexpr auto Descriptor_class_ids = ComponentDescriptor(
            ArchetypeName, "GeoPoints:class_ids",
            Loggable<rerun::components::ClassId>::ComponentType
        );

      public: // START of extensions from geo_points_ext.cpp:
        /// Creates a new GeoPoints object based on [EPSG:4326](https://epsg.io/4326) latitude and longitude (North/East-positive degrees).
        static GeoPoints from_lat_lon(Collection<components::LatLon> positions_) {
            return GeoPoints(std::move(positions_));
        }

        // END of extensions from geo_points_ext.cpp, start of generated code:

      public:
        GeoPoints() = default;
        GeoPoints(GeoPoints&& other) = default;
        GeoPoints(const GeoPoints& other) = default;
        GeoPoints& operator=(const GeoPoints& other) = default;
        GeoPoints& operator=(GeoPoints&& other) = default;

        explicit GeoPoints(Collection<rerun::components::LatLon> _positions)
            : positions(ComponentBatch::from_loggable(std::move(_positions), Descriptor_positions)
                            .value_or_throw()) {}

        /// Update only some specific fields of a `GeoPoints`.
        static GeoPoints update_fields() {
            return GeoPoints();
        }

        /// Clear all the fields of a `GeoPoints`.
        static GeoPoints clear_fields();

        /// The [EPSG:4326](https://epsg.io/4326) coordinates for the points (North/East-positive degrees).
        GeoPoints with_positions(const Collection<rerun::components::LatLon>& _positions) && {
            positions =
                ComponentBatch::from_loggable(_positions, Descriptor_positions).value_or_throw();
            return std::move(*this);
        }

        /// Optional radii for the points, effectively turning them into circles.
        ///
        /// *Note*: scene units radiii are interpreted as meters.
        GeoPoints with_radii(const Collection<rerun::components::Radius>& _radii) && {
            radii = ComponentBatch::from_loggable(_radii, Descriptor_radii).value_or_throw();
            return std::move(*this);
        }

        /// Optional colors for the points.
        GeoPoints with_colors(const Collection<rerun::components::Color>& _colors) && {
            colors = ComponentBatch::from_loggable(_colors, Descriptor_colors).value_or_throw();
            return std::move(*this);
        }

        /// Optional class Ids for the points.
        ///
        /// The `components::ClassId` provides colors if not specified explicitly.
        GeoPoints with_class_ids(const Collection<rerun::components::ClassId>& _class_ids) && {
            class_ids =
                ComponentBatch::from_loggable(_class_ids, Descriptor_class_ids).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::GeoPoints> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(const archetypes::GeoPoints& archetype
        );
    };
} // namespace rerun
