// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/mcap_schema.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/blob.hpp"
#include "../components/schema_id.hpp"
#include "../components/text.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: A schema definition that describes the structure of messages in an MCAP file.
    ///
    /// Schemas define the data types and field structures used by messages in MCAP channels.
    /// They provide the blueprint for interpreting message payloads, specifying field names,
    /// types, and organization. Each schema is referenced by channels to indicate how their
    /// messages should be decoded and understood.
    ///
    /// See also `archetypes::McapChannel` for channels that reference these schemas,
    /// `archetypes::McapMessage` for the messages that conform to these schemas, and the
    /// [MCAP specification](https://mcap.dev/) for complete format details.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct McapSchema {
        /// Unique identifier for this schema within the MCAP file.
        ///
        /// Schema IDs must be unique within an MCAP file and are referenced by channels
        /// to specify their message structure. A single schema can be shared across multiple channels.
        std::optional<ComponentBatch> id;

        /// Human-readable name identifying this schema.
        ///
        /// Schema names typically describe the message type or data structure
        /// (e.g., `"geometry_msgs/msg/Twist"`, `"sensor_msgs/msg/Image"`, `"MyCustomMessage"`).
        std::optional<ComponentBatch> name;

        /// The schema definition format used to describe the message structure.
        ///
        /// Common schema encodings include:
        /// * `protobuf` - [Protocol Buffers](https://mcap.dev/spec/registry#protobuf-1) schema definition
        /// * `ros1msg` - [ROS1](https://mcap.dev/spec/registry#ros1msg) message definition format
        /// * `ros2msg` - [ROS2](https://mcap.dev/spec/registry#ros2msg) message definition format
        /// * `jsonschema` - [JSON Schema](https://mcap.dev/spec/registry#jsonschema) specification
        /// * `flatbuffer` - [FlatBuffers](https://mcap.dev/spec/registry#flatbuffer) schema definition
        std::optional<ComponentBatch> encoding;

        /// The schema definition content as binary data.
        ///
        /// This contains the actual schema specification in the format indicated by the
        /// `encoding` field. For text-based schemas (like ROS message definitions or JSON Schema),
        /// this is typically UTF-8 encoded text. For binary schema formats, this contains
        /// the serialized schema data.
        std::optional<ComponentBatch> data;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.McapSchema";

        /// `ComponentDescriptor` for the `id` field.
        static constexpr auto Descriptor_id = ComponentDescriptor(
            ArchetypeName, "McapSchema:id", Loggable<rerun::components::SchemaId>::ComponentType
        );
        /// `ComponentDescriptor` for the `name` field.
        static constexpr auto Descriptor_name = ComponentDescriptor(
            ArchetypeName, "McapSchema:name", Loggable<rerun::components::Text>::ComponentType
        );
        /// `ComponentDescriptor` for the `encoding` field.
        static constexpr auto Descriptor_encoding = ComponentDescriptor(
            ArchetypeName, "McapSchema:encoding", Loggable<rerun::components::Text>::ComponentType
        );
        /// `ComponentDescriptor` for the `data` field.
        static constexpr auto Descriptor_data = ComponentDescriptor(
            ArchetypeName, "McapSchema:data", Loggable<rerun::components::Blob>::ComponentType
        );

      public:
        McapSchema() = default;
        McapSchema(McapSchema&& other) = default;
        McapSchema(const McapSchema& other) = default;
        McapSchema& operator=(const McapSchema& other) = default;
        McapSchema& operator=(McapSchema&& other) = default;

        explicit McapSchema(
            rerun::components::SchemaId _id, rerun::components::Text _name,
            rerun::components::Text _encoding, rerun::components::Blob _data
        )
            : id(ComponentBatch::from_loggable(std::move(_id), Descriptor_id).value_or_throw()),
              name(ComponentBatch::from_loggable(std::move(_name), Descriptor_name).value_or_throw()
              ),
              encoding(ComponentBatch::from_loggable(std::move(_encoding), Descriptor_encoding)
                           .value_or_throw()),
              data(ComponentBatch::from_loggable(std::move(_data), Descriptor_data).value_or_throw()
              ) {}

        /// Update only some specific fields of a `McapSchema`.
        static McapSchema update_fields() {
            return McapSchema();
        }

        /// Clear all the fields of a `McapSchema`.
        static McapSchema clear_fields();

        /// Unique identifier for this schema within the MCAP file.
        ///
        /// Schema IDs must be unique within an MCAP file and are referenced by channels
        /// to specify their message structure. A single schema can be shared across multiple channels.
        McapSchema with_id(const rerun::components::SchemaId& _id) && {
            id = ComponentBatch::from_loggable(_id, Descriptor_id).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `id` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_id` should
        /// be used when logging a single row's worth of data.
        McapSchema with_many_id(const Collection<rerun::components::SchemaId>& _id) && {
            id = ComponentBatch::from_loggable(_id, Descriptor_id).value_or_throw();
            return std::move(*this);
        }

        /// Human-readable name identifying this schema.
        ///
        /// Schema names typically describe the message type or data structure
        /// (e.g., `"geometry_msgs/msg/Twist"`, `"sensor_msgs/msg/Image"`, `"MyCustomMessage"`).
        McapSchema with_name(const rerun::components::Text& _name) && {
            name = ComponentBatch::from_loggable(_name, Descriptor_name).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `name` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_name` should
        /// be used when logging a single row's worth of data.
        McapSchema with_many_name(const Collection<rerun::components::Text>& _name) && {
            name = ComponentBatch::from_loggable(_name, Descriptor_name).value_or_throw();
            return std::move(*this);
        }

        /// The schema definition format used to describe the message structure.
        ///
        /// Common schema encodings include:
        /// * `protobuf` - [Protocol Buffers](https://mcap.dev/spec/registry#protobuf-1) schema definition
        /// * `ros1msg` - [ROS1](https://mcap.dev/spec/registry#ros1msg) message definition format
        /// * `ros2msg` - [ROS2](https://mcap.dev/spec/registry#ros2msg) message definition format
        /// * `jsonschema` - [JSON Schema](https://mcap.dev/spec/registry#jsonschema) specification
        /// * `flatbuffer` - [FlatBuffers](https://mcap.dev/spec/registry#flatbuffer) schema definition
        McapSchema with_encoding(const rerun::components::Text& _encoding) && {
            encoding =
                ComponentBatch::from_loggable(_encoding, Descriptor_encoding).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `encoding` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_encoding` should
        /// be used when logging a single row's worth of data.
        McapSchema with_many_encoding(const Collection<rerun::components::Text>& _encoding) && {
            encoding =
                ComponentBatch::from_loggable(_encoding, Descriptor_encoding).value_or_throw();
            return std::move(*this);
        }

        /// The schema definition content as binary data.
        ///
        /// This contains the actual schema specification in the format indicated by the
        /// `encoding` field. For text-based schemas (like ROS message definitions or JSON Schema),
        /// this is typically UTF-8 encoded text. For binary schema formats, this contains
        /// the serialized schema data.
        McapSchema with_data(const rerun::components::Blob& _data) && {
            data = ComponentBatch::from_loggable(_data, Descriptor_data).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `data` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_data` should
        /// be used when logging a single row's worth of data.
        McapSchema with_many_data(const Collection<rerun::components::Blob>& _data) && {
            data = ComponentBatch::from_loggable(_data, Descriptor_data).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::McapSchema> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(const archetypes::McapSchema& archetype
        );
    };
} // namespace rerun
