// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/mcap_statistics.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/channel_message_counts.hpp"
#include "../components/count.hpp"
#include "../components/timestamp.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: Recording-level statistics about an MCAP file, logged as a part of `archetypes::RecordingInfo`.
    ///
    /// This archetype contains summary information about an entire MCAP recording, including
    /// counts of messages, schemas, channels, and other records, as well as timing information
    /// spanning the full recording duration. It is typically logged once per recording to provide
    /// an overview of the dataset's structure and content.
    ///
    /// See also `archetypes::McapChannel` for individual channel definitions,
    /// `archetypes::McapMessage` for message content, `archetypes::McapSchema` for schema definitions,
    /// and the [MCAP specification](https://mcap.dev/) for complete format details.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct McapStatistics {
        /// Total number of data messages contained in the MCAP recording.
        ///
        /// This count includes all timestamped data messages but excludes metadata records,
        /// schema definitions, and other non-message records.
        std::optional<ComponentBatch> message_count;

        /// Number of unique schema definitions in the recording.
        ///
        /// Each schema defines the structure for one or more message types used by channels.
        std::optional<ComponentBatch> schema_count;

        /// Number of channels defined in the recording.
        ///
        /// Each channel represents a unique topic and encoding combination for publishing messages.
        std::optional<ComponentBatch> channel_count;

        /// Number of file attachments embedded in the recording.
        ///
        /// Attachments can include calibration files, configuration data, or other auxiliary files.
        std::optional<ComponentBatch> attachment_count;

        /// Number of metadata records providing additional context about the recording.
        ///
        /// Metadata records contain key-value pairs with information about the recording environment,
        /// system configuration, or other contextual data.
        std::optional<ComponentBatch> metadata_count;

        /// Number of data chunks used to organize messages in the file.
        ///
        /// Chunks group related messages together for efficient storage and indexed access.
        std::optional<ComponentBatch> chunk_count;

        /// Timestamp of the earliest message in the recording.
        ///
        /// This marks the beginning of the recorded data timeline.
        std::optional<ComponentBatch> message_start_time;

        /// Timestamp of the latest message in the recording.
        ///
        /// Together with `message_start_time`, this defines the total duration of the recording.
        std::optional<ComponentBatch> message_end_time;

        /// Detailed breakdown of message counts per channel.
        std::optional<ComponentBatch> channel_message_counts;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.McapStatistics";

        /// `ComponentDescriptor` for the `message_count` field.
        static constexpr auto Descriptor_message_count = ComponentDescriptor(
            ArchetypeName, "McapStatistics:message_count",
            Loggable<rerun::components::Count>::ComponentType
        );
        /// `ComponentDescriptor` for the `schema_count` field.
        static constexpr auto Descriptor_schema_count = ComponentDescriptor(
            ArchetypeName, "McapStatistics:schema_count",
            Loggable<rerun::components::Count>::ComponentType
        );
        /// `ComponentDescriptor` for the `channel_count` field.
        static constexpr auto Descriptor_channel_count = ComponentDescriptor(
            ArchetypeName, "McapStatistics:channel_count",
            Loggable<rerun::components::Count>::ComponentType
        );
        /// `ComponentDescriptor` for the `attachment_count` field.
        static constexpr auto Descriptor_attachment_count = ComponentDescriptor(
            ArchetypeName, "McapStatistics:attachment_count",
            Loggable<rerun::components::Count>::ComponentType
        );
        /// `ComponentDescriptor` for the `metadata_count` field.
        static constexpr auto Descriptor_metadata_count = ComponentDescriptor(
            ArchetypeName, "McapStatistics:metadata_count",
            Loggable<rerun::components::Count>::ComponentType
        );
        /// `ComponentDescriptor` for the `chunk_count` field.
        static constexpr auto Descriptor_chunk_count = ComponentDescriptor(
            ArchetypeName, "McapStatistics:chunk_count",
            Loggable<rerun::components::Count>::ComponentType
        );
        /// `ComponentDescriptor` for the `message_start_time` field.
        static constexpr auto Descriptor_message_start_time = ComponentDescriptor(
            ArchetypeName, "McapStatistics:message_start_time",
            Loggable<rerun::components::Timestamp>::ComponentType
        );
        /// `ComponentDescriptor` for the `message_end_time` field.
        static constexpr auto Descriptor_message_end_time = ComponentDescriptor(
            ArchetypeName, "McapStatistics:message_end_time",
            Loggable<rerun::components::Timestamp>::ComponentType
        );
        /// `ComponentDescriptor` for the `channel_message_counts` field.
        static constexpr auto Descriptor_channel_message_counts = ComponentDescriptor(
            ArchetypeName, "McapStatistics:channel_message_counts",
            Loggable<rerun::components::ChannelMessageCounts>::ComponentType
        );

      public:
        McapStatistics() = default;
        McapStatistics(McapStatistics&& other) = default;
        McapStatistics(const McapStatistics& other) = default;
        McapStatistics& operator=(const McapStatistics& other) = default;
        McapStatistics& operator=(McapStatistics&& other) = default;

        explicit McapStatistics(
            rerun::components::Count _message_count, rerun::components::Count _schema_count,
            rerun::components::Count _channel_count, rerun::components::Count _attachment_count,
            rerun::components::Count _metadata_count, rerun::components::Count _chunk_count,
            rerun::components::Timestamp _message_start_time,
            rerun::components::Timestamp _message_end_time
        )
            : message_count(
                  ComponentBatch::from_loggable(std::move(_message_count), Descriptor_message_count)
                      .value_or_throw()
              ),
              schema_count(
                  ComponentBatch::from_loggable(std::move(_schema_count), Descriptor_schema_count)
                      .value_or_throw()
              ),
              channel_count(
                  ComponentBatch::from_loggable(std::move(_channel_count), Descriptor_channel_count)
                      .value_or_throw()
              ),
              attachment_count(ComponentBatch::from_loggable(
                                   std::move(_attachment_count), Descriptor_attachment_count
              )
                                   .value_or_throw()),
              metadata_count(ComponentBatch::from_loggable(
                                 std::move(_metadata_count), Descriptor_metadata_count
              )
                                 .value_or_throw()),
              chunk_count(
                  ComponentBatch::from_loggable(std::move(_chunk_count), Descriptor_chunk_count)
                      .value_or_throw()
              ),
              message_start_time(ComponentBatch::from_loggable(
                                     std::move(_message_start_time), Descriptor_message_start_time
              )
                                     .value_or_throw()),
              message_end_time(ComponentBatch::from_loggable(
                                   std::move(_message_end_time), Descriptor_message_end_time
              )
                                   .value_or_throw()) {}

        /// Update only some specific fields of a `McapStatistics`.
        static McapStatistics update_fields() {
            return McapStatistics();
        }

        /// Clear all the fields of a `McapStatistics`.
        static McapStatistics clear_fields();

        /// Total number of data messages contained in the MCAP recording.
        ///
        /// This count includes all timestamped data messages but excludes metadata records,
        /// schema definitions, and other non-message records.
        McapStatistics with_message_count(const rerun::components::Count& _message_count) && {
            message_count = ComponentBatch::from_loggable(_message_count, Descriptor_message_count)
                                .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `message_count` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_message_count` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_message_count(
            const Collection<rerun::components::Count>& _message_count
        ) && {
            message_count = ComponentBatch::from_loggable(_message_count, Descriptor_message_count)
                                .value_or_throw();
            return std::move(*this);
        }

        /// Number of unique schema definitions in the recording.
        ///
        /// Each schema defines the structure for one or more message types used by channels.
        McapStatistics with_schema_count(const rerun::components::Count& _schema_count) && {
            schema_count = ComponentBatch::from_loggable(_schema_count, Descriptor_schema_count)
                               .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `schema_count` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_schema_count` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_schema_count(
            const Collection<rerun::components::Count>& _schema_count
        ) && {
            schema_count = ComponentBatch::from_loggable(_schema_count, Descriptor_schema_count)
                               .value_or_throw();
            return std::move(*this);
        }

        /// Number of channels defined in the recording.
        ///
        /// Each channel represents a unique topic and encoding combination for publishing messages.
        McapStatistics with_channel_count(const rerun::components::Count& _channel_count) && {
            channel_count = ComponentBatch::from_loggable(_channel_count, Descriptor_channel_count)
                                .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `channel_count` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_channel_count` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_channel_count(
            const Collection<rerun::components::Count>& _channel_count
        ) && {
            channel_count = ComponentBatch::from_loggable(_channel_count, Descriptor_channel_count)
                                .value_or_throw();
            return std::move(*this);
        }

        /// Number of file attachments embedded in the recording.
        ///
        /// Attachments can include calibration files, configuration data, or other auxiliary files.
        McapStatistics with_attachment_count(const rerun::components::Count& _attachment_count) && {
            attachment_count =
                ComponentBatch::from_loggable(_attachment_count, Descriptor_attachment_count)
                    .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `attachment_count` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_attachment_count` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_attachment_count(
            const Collection<rerun::components::Count>& _attachment_count
        ) && {
            attachment_count =
                ComponentBatch::from_loggable(_attachment_count, Descriptor_attachment_count)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Number of metadata records providing additional context about the recording.
        ///
        /// Metadata records contain key-value pairs with information about the recording environment,
        /// system configuration, or other contextual data.
        McapStatistics with_metadata_count(const rerun::components::Count& _metadata_count) && {
            metadata_count =
                ComponentBatch::from_loggable(_metadata_count, Descriptor_metadata_count)
                    .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `metadata_count` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_metadata_count` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_metadata_count(
            const Collection<rerun::components::Count>& _metadata_count
        ) && {
            metadata_count =
                ComponentBatch::from_loggable(_metadata_count, Descriptor_metadata_count)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Number of data chunks used to organize messages in the file.
        ///
        /// Chunks group related messages together for efficient storage and indexed access.
        McapStatistics with_chunk_count(const rerun::components::Count& _chunk_count) && {
            chunk_count = ComponentBatch::from_loggable(_chunk_count, Descriptor_chunk_count)
                              .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `chunk_count` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_chunk_count` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_chunk_count(
            const Collection<rerun::components::Count>& _chunk_count
        ) && {
            chunk_count = ComponentBatch::from_loggable(_chunk_count, Descriptor_chunk_count)
                              .value_or_throw();
            return std::move(*this);
        }

        /// Timestamp of the earliest message in the recording.
        ///
        /// This marks the beginning of the recorded data timeline.
        McapStatistics with_message_start_time(
            const rerun::components::Timestamp& _message_start_time
        ) && {
            message_start_time =
                ComponentBatch::from_loggable(_message_start_time, Descriptor_message_start_time)
                    .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `message_start_time` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_message_start_time` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_message_start_time(
            const Collection<rerun::components::Timestamp>& _message_start_time
        ) && {
            message_start_time =
                ComponentBatch::from_loggable(_message_start_time, Descriptor_message_start_time)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Timestamp of the latest message in the recording.
        ///
        /// Together with `message_start_time`, this defines the total duration of the recording.
        McapStatistics with_message_end_time(const rerun::components::Timestamp& _message_end_time
        ) && {
            message_end_time =
                ComponentBatch::from_loggable(_message_end_time, Descriptor_message_end_time)
                    .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `message_end_time` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_message_end_time` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_message_end_time(
            const Collection<rerun::components::Timestamp>& _message_end_time
        ) && {
            message_end_time =
                ComponentBatch::from_loggable(_message_end_time, Descriptor_message_end_time)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Detailed breakdown of message counts per channel.
        McapStatistics with_channel_message_counts(
            const rerun::components::ChannelMessageCounts& _channel_message_counts
        ) && {
            channel_message_counts = ComponentBatch::from_loggable(
                                         _channel_message_counts,
                                         Descriptor_channel_message_counts
            )
                                         .value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `channel_message_counts` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_channel_message_counts` should
        /// be used when logging a single row's worth of data.
        McapStatistics with_many_channel_message_counts(
            const Collection<rerun::components::ChannelMessageCounts>& _channel_message_counts
        ) && {
            channel_message_counts = ComponentBatch::from_loggable(
                                         _channel_message_counts,
                                         Descriptor_channel_message_counts
            )
                                         .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::McapStatistics> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::McapStatistics& archetype
        );
    };
} // namespace rerun
