// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/series_points.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/color.hpp"
#include "../components/marker_shape.hpp"
#include "../components/marker_size.hpp"
#include "../components/name.hpp"
#include "../components/series_visible.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: Define the style properties for one or more point series (scatter plot) in a chart.
    ///
    /// This archetype only provides styling information.
    /// Changes over time are supported for most but not all its fields (see respective fields for details),
    /// it's generally recommended to log this type as static.
    ///
    /// The underlying data needs to be logged to the same entity-path using `archetypes::Scalars`.
    /// Dimensionality of the scalar arrays logged at each time point is assumed to be the same over time.
    ///
    /// ## Example
    ///
    /// ### Point series
    /// ![image](https://static.rerun.io/series_point_style/82207a705da6c086b28ce161db1db9e8b12258b7/full.png)
    ///
    /// ```cpp
    /// #include <rerun.hpp>
    ///
    /// #include <cmath>
    ///
    /// constexpr float TAU = 6.28318530717958647692528676655900577f;
    ///
    /// int main() {
    ///     const auto rec = rerun::RecordingStream("rerun_example_series_point_style");
    ///     rec.spawn().exit_on_failure();
    ///
    ///     // Set up plot styling:
    ///     // They are logged static as they don't change over time and apply to all timelines.
    ///     // Log two point series under a shared root so that they show in the same plot by default.
    ///     rec.log_static(
    ///         "trig/sin",
    ///         rerun::SeriesPoints()
    ///             .with_colors(rerun::Rgba32{255, 0, 0})
    ///             .with_names("sin(0.01t)")
    ///             .with_markers(rerun::components::MarkerShape::Circle)
    ///             .with_marker_sizes(4.0f)
    ///     );
    ///     rec.log_static(
    ///         "trig/cos",
    ///         rerun::SeriesPoints()
    ///             .with_colors(rerun::Rgba32{0, 255, 0})
    ///             .with_names("cos(0.01t)")
    ///             .with_markers(rerun::components::MarkerShape::Cross)
    ///             .with_marker_sizes(2.0f)
    ///     );
    ///
    ///     // Log the data on a timeline called "step".
    ///     for (int t = 0; t <static_cast<int>(TAU * 2.0 * 10.0); ++t) {
    ///         rec.set_time_sequence("step", t);
    ///
    ///         rec.log("trig/sin", rerun::Scalars(sin(static_cast<double>(t) / 10.0)));
    ///         rec.log("trig/cos", rerun::Scalars(cos(static_cast<double>(t) / 10.0)));
    ///     }
    /// }
    /// ```
    struct SeriesPoints {
        /// Color for the corresponding series.
        ///
        /// May change over time, but can cause discontinuities in the line.
        std::optional<ComponentBatch> colors;

        /// What shape to use to represent the point
        ///
        /// May change over time.
        std::optional<ComponentBatch> markers;

        /// Display name of the series.
        ///
        /// Used in the legend. Expected to be unchanging over time.
        std::optional<ComponentBatch> names;

        /// Which lines are visible.
        ///
        /// If not set, all line series on this entity are visible.
        /// Unlike with the regular visibility property of the entire entity, any series that is hidden
        /// via this property will still be visible in the legend.
        ///
        /// May change over time.
        std::optional<ComponentBatch> visible_series;

        /// Sizes of the markers.
        ///
        /// May change over time.
        std::optional<ComponentBatch> marker_sizes;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.SeriesPoints";

        /// `ComponentDescriptor` for the `colors` field.
        static constexpr auto Descriptor_colors = ComponentDescriptor(
            ArchetypeName, "SeriesPoints:colors", Loggable<rerun::components::Color>::ComponentType
        );
        /// `ComponentDescriptor` for the `markers` field.
        static constexpr auto Descriptor_markers = ComponentDescriptor(
            ArchetypeName, "SeriesPoints:markers",
            Loggable<rerun::components::MarkerShape>::ComponentType
        );
        /// `ComponentDescriptor` for the `names` field.
        static constexpr auto Descriptor_names = ComponentDescriptor(
            ArchetypeName, "SeriesPoints:names", Loggable<rerun::components::Name>::ComponentType
        );
        /// `ComponentDescriptor` for the `visible_series` field.
        static constexpr auto Descriptor_visible_series = ComponentDescriptor(
            ArchetypeName, "SeriesPoints:visible_series",
            Loggable<rerun::components::SeriesVisible>::ComponentType
        );
        /// `ComponentDescriptor` for the `marker_sizes` field.
        static constexpr auto Descriptor_marker_sizes = ComponentDescriptor(
            ArchetypeName, "SeriesPoints:marker_sizes",
            Loggable<rerun::components::MarkerSize>::ComponentType
        );

      public: // START of extensions from series_points_ext.cpp:
        // Overload needed to avoid confusion with passing single strings.
        /// Display name of the series.
        ///
        /// Used in the legend. Expected to be unchanging over time.
        SeriesPoints with_names(const char* _name) && {
            names = ComponentBatch::from_loggable(rerun::components::Name(_name), Descriptor_names)
                        .value_or_throw();
            return std::move(*this);
        }

        // END of extensions from series_points_ext.cpp, start of generated code:

      public:
        SeriesPoints() = default;
        SeriesPoints(SeriesPoints&& other) = default;
        SeriesPoints(const SeriesPoints& other) = default;
        SeriesPoints& operator=(const SeriesPoints& other) = default;
        SeriesPoints& operator=(SeriesPoints&& other) = default;

        /// Update only some specific fields of a `SeriesPoints`.
        static SeriesPoints update_fields() {
            return SeriesPoints();
        }

        /// Clear all the fields of a `SeriesPoints`.
        static SeriesPoints clear_fields();

        /// Color for the corresponding series.
        ///
        /// May change over time, but can cause discontinuities in the line.
        SeriesPoints with_colors(const Collection<rerun::components::Color>& _colors) && {
            colors = ComponentBatch::from_loggable(_colors, Descriptor_colors).value_or_throw();
            return std::move(*this);
        }

        /// What shape to use to represent the point
        ///
        /// May change over time.
        SeriesPoints with_markers(const Collection<rerun::components::MarkerShape>& _markers) && {
            markers = ComponentBatch::from_loggable(_markers, Descriptor_markers).value_or_throw();
            return std::move(*this);
        }

        /// Display name of the series.
        ///
        /// Used in the legend. Expected to be unchanging over time.
        SeriesPoints with_names(const Collection<rerun::components::Name>& _names) && {
            names = ComponentBatch::from_loggable(_names, Descriptor_names).value_or_throw();
            return std::move(*this);
        }

        /// Which lines are visible.
        ///
        /// If not set, all line series on this entity are visible.
        /// Unlike with the regular visibility property of the entire entity, any series that is hidden
        /// via this property will still be visible in the legend.
        ///
        /// May change over time.
        SeriesPoints with_visible_series(
            const Collection<rerun::components::SeriesVisible>& _visible_series
        ) && {
            visible_series =
                ComponentBatch::from_loggable(_visible_series, Descriptor_visible_series)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Sizes of the markers.
        ///
        /// May change over time.
        SeriesPoints with_marker_sizes(
            const Collection<rerun::components::MarkerSize>& _marker_sizes
        ) && {
            marker_sizes = ComponentBatch::from_loggable(_marker_sizes, Descriptor_marker_sizes)
                               .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::SeriesPoints> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::SeriesPoints& archetype
        );
    };
} // namespace rerun
