// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/blueprint/archetypes/force_collision_radius.fbs".

#pragma once

#include "../../blueprint/components/enabled.hpp"
#include "../../blueprint/components/force_iterations.hpp"
#include "../../blueprint/components/force_strength.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Resolves collisions between the bounding circles, according to the radius of the nodes.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct ForceCollisionRadius {
        /// Whether the collision force is enabled.
        ///
        /// The collision force resolves collisions between nodes based on the bounding circle defined by their radius.
        std::optional<ComponentBatch> enabled;

        /// The strength of the force.
        std::optional<ComponentBatch> strength;

        /// Specifies how often this force should be applied per iteration.
        ///
        /// Increasing this parameter can lead to better results at the cost of longer computation time.
        std::optional<ComponentBatch> iterations;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] =
            "rerun.blueprint.archetypes.ForceCollisionRadius";

        /// `ComponentDescriptor` for the `enabled` field.
        static constexpr auto Descriptor_enabled = ComponentDescriptor(
            ArchetypeName, "ForceCollisionRadius:enabled",
            Loggable<rerun::blueprint::components::Enabled>::ComponentType
        );
        /// `ComponentDescriptor` for the `strength` field.
        static constexpr auto Descriptor_strength = ComponentDescriptor(
            ArchetypeName, "ForceCollisionRadius:strength",
            Loggable<rerun::blueprint::components::ForceStrength>::ComponentType
        );
        /// `ComponentDescriptor` for the `iterations` field.
        static constexpr auto Descriptor_iterations = ComponentDescriptor(
            ArchetypeName, "ForceCollisionRadius:iterations",
            Loggable<rerun::blueprint::components::ForceIterations>::ComponentType
        );

      public:
        ForceCollisionRadius() = default;
        ForceCollisionRadius(ForceCollisionRadius&& other) = default;
        ForceCollisionRadius(const ForceCollisionRadius& other) = default;
        ForceCollisionRadius& operator=(const ForceCollisionRadius& other) = default;
        ForceCollisionRadius& operator=(ForceCollisionRadius&& other) = default;

        /// Update only some specific fields of a `ForceCollisionRadius`.
        static ForceCollisionRadius update_fields() {
            return ForceCollisionRadius();
        }

        /// Clear all the fields of a `ForceCollisionRadius`.
        static ForceCollisionRadius clear_fields();

        /// Whether the collision force is enabled.
        ///
        /// The collision force resolves collisions between nodes based on the bounding circle defined by their radius.
        ForceCollisionRadius with_enabled(const rerun::blueprint::components::Enabled& _enabled
        ) && {
            enabled = ComponentBatch::from_loggable(_enabled, Descriptor_enabled).value_or_throw();
            return std::move(*this);
        }

        /// The strength of the force.
        ForceCollisionRadius with_strength(
            const rerun::blueprint::components::ForceStrength& _strength
        ) && {
            strength =
                ComponentBatch::from_loggable(_strength, Descriptor_strength).value_or_throw();
            return std::move(*this);
        }

        /// Specifies how often this force should be applied per iteration.
        ///
        /// Increasing this parameter can lead to better results at the cost of longer computation time.
        ForceCollisionRadius with_iterations(
            const rerun::blueprint::components::ForceIterations& _iterations
        ) && {
            iterations =
                ComponentBatch::from_loggable(_iterations, Descriptor_iterations).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::ForceCollisionRadius> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::ForceCollisionRadius& archetype
        );
    };
} // namespace rerun
