// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/blueprint/archetypes/background.fbs".

#pragma once

#include "../../blueprint/components/enabled.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../components/color.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Configuration of a background in a plot view.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct PlotBackground {
        /// Color used for the background.
        std::optional<ComponentBatch> color;

        /// Should the grid be drawn?
        std::optional<ComponentBatch> show_grid;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.PlotBackground";

        /// `ComponentDescriptor` for the `color` field.
        static constexpr auto Descriptor_color = ComponentDescriptor(
            ArchetypeName, "PlotBackground:color", Loggable<rerun::components::Color>::ComponentType
        );
        /// `ComponentDescriptor` for the `show_grid` field.
        static constexpr auto Descriptor_show_grid = ComponentDescriptor(
            ArchetypeName, "PlotBackground:show_grid",
            Loggable<rerun::blueprint::components::Enabled>::ComponentType
        );

      public:
        PlotBackground() = default;
        PlotBackground(PlotBackground&& other) = default;
        PlotBackground(const PlotBackground& other) = default;
        PlotBackground& operator=(const PlotBackground& other) = default;
        PlotBackground& operator=(PlotBackground&& other) = default;

        /// Update only some specific fields of a `PlotBackground`.
        static PlotBackground update_fields() {
            return PlotBackground();
        }

        /// Clear all the fields of a `PlotBackground`.
        static PlotBackground clear_fields();

        /// Color used for the background.
        PlotBackground with_color(const rerun::components::Color& _color) && {
            color = ComponentBatch::from_loggable(_color, Descriptor_color).value_or_throw();
            return std::move(*this);
        }

        /// Should the grid be drawn?
        PlotBackground with_show_grid(const rerun::blueprint::components::Enabled& _show_grid) && {
            show_grid =
                ComponentBatch::from_loggable(_show_grid, Descriptor_show_grid).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::PlotBackground> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::PlotBackground& archetype
        );
    };
} // namespace rerun
