// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/components/scalar.fbs".

#pragma once

#include "../datatypes/float64.hpp"
#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace rerun::components {
    /// **Component**: A scalar value, encoded as a 64-bit floating point.
    ///
    /// Used for time series plots.
    struct Scalar {
        rerun::datatypes::Float64 value;

      public:
        Scalar() = default;

        Scalar(rerun::datatypes::Float64 value_) : value(value_) {}

        Scalar& operator=(rerun::datatypes::Float64 value_) {
            value = value_;
            return *this;
        }

        Scalar(double value_) : value(value_) {}

        Scalar& operator=(double value_) {
            value = value_;
            return *this;
        }

        /// Cast to the underlying Float64 datatype
        operator rerun::datatypes::Float64() const {
            return value;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Float64) == sizeof(components::Scalar));

    /// \private
    template <>
    struct Loggable<components::Scalar> {
        static constexpr std::string_view ComponentType = "rerun.components.Scalar";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Float64>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::Scalar` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::Scalar* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Float64>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Float64>::to_arrow(
                    &instances->value,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
