// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/components/video_codec.fbs".

#pragma once

#include "../result.hpp"

#include <cstdint>
#include <memory>

namespace arrow {
    /// \private
    template <typename T>
    class NumericBuilder;

    class Array;
    class DataType;
    class UInt32Type;
    using UInt32Builder = NumericBuilder<UInt32Type>;
} // namespace arrow

namespace rerun::components {
    /// **Component**: The codec used to encode video stored in `components::VideoSample`.
    ///
    /// Support of these codecs by the Rerun Viewer is platform dependent.
    /// For more details see check the [video reference](https://rerun.io/docs/reference/video).
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    enum class VideoCodec : uint32_t {

        /// Advanced Video Coding (AVC/H.264)
        ///
        /// See <https://en.wikipedia.org/wiki/Advanced_Video_Coding>
        ///
        /// `components::VideoSample`s using this codec should be formatted according to Annex B specification.
        /// (Note that this is different from AVCC format found in MP4 files.
        /// To learn more about Annex B, check for instance <https://membrane.stream/learn/h264/3>)
        /// Key frames (IDR) require inclusion of a SPS (Sequence Parameter Set)
        ///
        /// Enum value is the fourcc for 'avc1' (the WebCodec string assigned to this codec) in big endian.
        H264 = 0x61766331,

        /// High Efficiency Video Coding (HEVC/H.265)
        ///
        /// See <https://en.wikipedia.org/wiki/High_Efficiency_Video_Coding>
        ///
        /// `components::VideoSample`s using this codec should be formatted according to Annex B specification.
        /// (Note that this is different from AVCC format found in MP4 files.
        /// To learn more about Annex B, check for instance <https://membrane.stream/learn/h264/3>)
        /// Key frames (IRAP) require inclusion of a SPS (Sequence Parameter Set)
        ///
        /// Enum value is the fourcc for 'hev1' (the WebCodec string assigned to this codec) in big endian.
        H265 = 0x68657631,
    };
} // namespace rerun::components

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<components::VideoCodec> {
        static constexpr std::string_view ComponentType = "rerun.components.VideoCodec";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::components::VideoCodec` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::VideoCodec* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::UInt32Builder* builder, const components::VideoCodec* elements,
            size_t num_elements
        );
    };
} // namespace rerun
