// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/recording_info.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/name.hpp"
#include "../components/timestamp.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: A list of properties associated with a recording.
    struct RecordingInfo {
        /// When the recording started.
        ///
        /// Should be an absolute time, i.e. relative to Unix Epoch.
        std::optional<ComponentBatch> start_time;

        /// A user-chosen name for the recording.
        std::optional<ComponentBatch> name;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.RecordingInfo";

        /// `ComponentDescriptor` for the `start_time` field.
        static constexpr auto Descriptor_start_time = ComponentDescriptor(
            ArchetypeName, "RecordingInfo:start_time",
            Loggable<rerun::components::Timestamp>::ComponentType
        );
        /// `ComponentDescriptor` for the `name` field.
        static constexpr auto Descriptor_name = ComponentDescriptor(
            ArchetypeName, "RecordingInfo:name", Loggable<rerun::components::Name>::ComponentType
        );

      public:
        RecordingInfo() = default;
        RecordingInfo(RecordingInfo&& other) = default;
        RecordingInfo(const RecordingInfo& other) = default;
        RecordingInfo& operator=(const RecordingInfo& other) = default;
        RecordingInfo& operator=(RecordingInfo&& other) = default;

        /// Update only some specific fields of a `RecordingInfo`.
        static RecordingInfo update_fields() {
            return RecordingInfo();
        }

        /// Clear all the fields of a `RecordingInfo`.
        static RecordingInfo clear_fields();

        /// When the recording started.
        ///
        /// Should be an absolute time, i.e. relative to Unix Epoch.
        RecordingInfo with_start_time(const rerun::components::Timestamp& _start_time) && {
            start_time =
                ComponentBatch::from_loggable(_start_time, Descriptor_start_time).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `start_time` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_start_time` should
        /// be used when logging a single row's worth of data.
        RecordingInfo with_many_start_time(
            const Collection<rerun::components::Timestamp>& _start_time
        ) && {
            start_time =
                ComponentBatch::from_loggable(_start_time, Descriptor_start_time).value_or_throw();
            return std::move(*this);
        }

        /// A user-chosen name for the recording.
        RecordingInfo with_name(const rerun::components::Name& _name) && {
            name = ComponentBatch::from_loggable(_name, Descriptor_name).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `name` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_name` should
        /// be used when logging a single row's worth of data.
        RecordingInfo with_many_name(const Collection<rerun::components::Name>& _name) && {
            name = ComponentBatch::from_loggable(_name, Descriptor_name).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::RecordingInfo> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::RecordingInfo& archetype
        );
    };
} // namespace rerun
