// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/components/video_sample.fbs".

#pragma once

#include "../collection.hpp"
#include "../datatypes/blob.hpp"
#include "../result.hpp"

#include <cstdint>
#include <memory>
#include <utility>

namespace rerun::components {
    /// **Component**: Video sample data (also known as "video chunk").
    ///
    /// Each video sample must contain enough data for exactly one video frame
    /// (this restriction may be relaxed in the future for some codecs).
    ///
    /// Keyframes may require additional data, for details see `components::VideoCodec`.
    struct VideoSample {
        rerun::datatypes::Blob buffer;

      public:
        VideoSample() = default;

        VideoSample(rerun::datatypes::Blob buffer_) : buffer(std::move(buffer_)) {}

        VideoSample& operator=(rerun::datatypes::Blob buffer_) {
            buffer = std::move(buffer_);
            return *this;
        }

        VideoSample(rerun::Collection<uint8_t> data_) : buffer(std::move(data_)) {}

        VideoSample& operator=(rerun::Collection<uint8_t> data_) {
            buffer = std::move(data_);
            return *this;
        }

        /// Cast to the underlying Blob datatype
        operator rerun::datatypes::Blob() const {
            return buffer;
        }
    };
} // namespace rerun::components

namespace rerun {
    static_assert(sizeof(rerun::datatypes::Blob) == sizeof(components::VideoSample));

    /// \private
    template <>
    struct Loggable<components::VideoSample> {
        static constexpr std::string_view ComponentType = "rerun.components.VideoSample";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype() {
            return Loggable<rerun::datatypes::Blob>::arrow_datatype();
        }

        /// Serializes an array of `rerun::components::VideoSample` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const components::VideoSample* instances, size_t num_instances
        ) {
            if (num_instances == 0) {
                return Loggable<rerun::datatypes::Blob>::to_arrow(nullptr, 0);
            } else if (instances == nullptr) {
                return rerun::Error(
                    ErrorCode::UnexpectedNullArgument,
                    "Passed array instances is null when num_elements> 0."
                );
            } else {
                return Loggable<rerun::datatypes::Blob>::to_arrow(
                    &instances->buffer,
                    num_instances
                );
            }
        }
    };
} // namespace rerun
