// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/archetypes/recording_properties.fbs".

#pragma once

#include "../collection.hpp"
#include "../component_batch.hpp"
#include "../component_column.hpp"
#include "../components/name.hpp"
#include "../components/timestamp.hpp"
#include "../indicator_component.hpp"
#include "../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::archetypes {
    /// **Archetype**: A list of properties associated with a recording.
    struct RecordingProperties {
        /// When the recording started.
        ///
        /// Should be an absolute time, i.e. relative to Unix Epoch.
        std::optional<ComponentBatch> start_time;

        /// A user-chosen name for the recording.
        std::optional<ComponentBatch> name;

      public:
        static constexpr const char IndicatorComponentName[] =
            "rerun.components.RecordingPropertiesIndicator";

        /// Indicator component, used to identify the archetype when converting to a list of components.
        using IndicatorComponent = rerun::components::IndicatorComponent<IndicatorComponentName>;
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.archetypes.RecordingProperties";

        /// `ComponentDescriptor` for the `start_time` field.
        static constexpr auto Descriptor_start_time = ComponentDescriptor(
            ArchetypeName, "start_time",
            Loggable<rerun::components::Timestamp>::Descriptor.component_name
        );
        /// `ComponentDescriptor` for the `name` field.
        static constexpr auto Descriptor_name = ComponentDescriptor(
            ArchetypeName, "name", Loggable<rerun::components::Name>::Descriptor.component_name
        );

      public:
        RecordingProperties() = default;
        RecordingProperties(RecordingProperties&& other) = default;
        RecordingProperties(const RecordingProperties& other) = default;
        RecordingProperties& operator=(const RecordingProperties& other) = default;
        RecordingProperties& operator=(RecordingProperties&& other) = default;

        /// Update only some specific fields of a `RecordingProperties`.
        static RecordingProperties update_fields() {
            return RecordingProperties();
        }

        /// Clear all the fields of a `RecordingProperties`.
        static RecordingProperties clear_fields();

        /// When the recording started.
        ///
        /// Should be an absolute time, i.e. relative to Unix Epoch.
        RecordingProperties with_start_time(const rerun::components::Timestamp& _start_time) && {
            start_time =
                ComponentBatch::from_loggable(_start_time, Descriptor_start_time).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `start_time` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_start_time` should
        /// be used when logging a single row's worth of data.
        RecordingProperties with_many_start_time(
            const Collection<rerun::components::Timestamp>& _start_time
        ) && {
            start_time =
                ComponentBatch::from_loggable(_start_time, Descriptor_start_time).value_or_throw();
            return std::move(*this);
        }

        /// A user-chosen name for the recording.
        RecordingProperties with_name(const rerun::components::Name& _name) && {
            name = ComponentBatch::from_loggable(_name, Descriptor_name).value_or_throw();
            return std::move(*this);
        }

        /// This method makes it possible to pack multiple `name` in a single component batch.
        ///
        /// This only makes sense when used in conjunction with `columns`. `with_name` should
        /// be used when logging a single row's worth of data.
        RecordingProperties with_many_name(const Collection<rerun::components::Name>& _name) && {
            name = ComponentBatch::from_loggable(_name, Descriptor_name).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<archetypes::RecordingProperties> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const archetypes::RecordingProperties& archetype
        );
    };
} // namespace rerun
