// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/datatypes/mat3x3.fbs".

#pragma once

#include "../component_descriptor.hpp"
#include "../rerun_sdk_export.hpp"
#include "../result.hpp"
#include "vec3d.hpp"

#include <array>
#include <cstdint>
#include <memory>

namespace arrow {
    class Array;
    class DataType;
    class FixedSizeListBuilder;
} // namespace arrow

namespace rerun::datatypes {
    /// **Datatype**: A 3x3 Matrix.
    ///
    /// Matrices in Rerun are stored as flat list of coefficients in column-major order:
    /// ```text
    ///             column 0       column 1       column 2
    ///        -------------------------------------------------
    /// row 0 | flat_columns[0] flat_columns[3] flat_columns[6]
    /// row 1 | flat_columns[1] flat_columns[4] flat_columns[7]
    /// row 2 | flat_columns[2] flat_columns[5] flat_columns[8]
    /// ```
    struct Mat3x3 {
        /// Flat list of matrix coefficients in column-major order.
        std::array<float, 9> flat_columns;

      public: // START of extensions from mat3x3_ext.cpp:
        static const Mat3x3 IDENTITY;
        static const Mat3x3 INVALID;

        /// Creates a new 3x3 matrix from 3 *columns* of 3 elements each.
        Mat3x3(const Vec3D (&columns)[3])
            : flat_columns{
                  columns[0].x(),
                  columns[0].y(),
                  columns[0].z(),
                  columns[1].x(),
                  columns[1].y(),
                  columns[1].z(),
                  columns[2].x(),
                  columns[2].y(),
                  columns[2].z(),
              } {}

        /// Construct a new 3x3 matrix from a pointer to 9 floats (in column major order).
        explicit Mat3x3(const float* elements)
            : flat_columns{
                  elements[0],
                  elements[1],
                  elements[2],
                  elements[3],
                  elements[4],
                  elements[5],
                  elements[6],
                  elements[7],
                  elements[8],
              } {}

        // END of extensions from mat3x3_ext.cpp, start of generated code:

      public:
        Mat3x3() = default;

        Mat3x3(std::array<float, 9> flat_columns_) : flat_columns(flat_columns_) {}

        Mat3x3& operator=(std::array<float, 9> flat_columns_) {
            flat_columns = flat_columns_;
            return *this;
        }
    };
} // namespace rerun::datatypes

namespace rerun {
    template <typename T>
    struct Loggable;

    /// \private
    template <>
    struct Loggable<datatypes::Mat3x3> {
        static constexpr ComponentDescriptor Descriptor = "rerun.datatypes.Mat3x3";

        /// Returns the arrow data type this type corresponds to.
        static const std::shared_ptr<arrow::DataType>& arrow_datatype();

        /// Serializes an array of `rerun::datatypes::Mat3x3` into an arrow array.
        static Result<std::shared_ptr<arrow::Array>> to_arrow(
            const datatypes::Mat3x3* instances, size_t num_instances
        );

        /// Fills an arrow array builder with an array of this type.
        static rerun::Error fill_arrow_array_builder(
            arrow::FixedSizeListBuilder* builder, const datatypes::Mat3x3* elements,
            size_t num_elements
        );
    };
} // namespace rerun
