// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/blueprint/archetypes/eye_controls3d.fbs".

#pragma once

#include "../../blueprint/components/angular_speed.hpp"
#include "../../blueprint/components/eye3d_kind.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../components/entity_path.hpp"
#include "../../components/linear_speed.hpp"
#include "../../components/position3d.hpp"
#include "../../components/vector3d.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: The controls for the 3D eye in a spatial 3D view.
    ///
    /// This configures the camera through which the 3D scene is viewed.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct EyeControls3D {
        /// The kind of the eye for the spatial 3D view.
        ///
        /// This controls how the eye movement behaves when the user interact with the view.
        /// Defaults to orbital.
        std::optional<ComponentBatch> kind;

        /// The cameras current position.
        std::optional<ComponentBatch> position;

        /// The position the camera is currently looking at.
        ///
        /// If this is an orbital camera, this also is the center it orbits around.
        ///
        /// By default this is the center of the scene bounds.
        std::optional<ComponentBatch> look_target;

        /// The up-axis of the eye itself, in world-space.
        ///
        /// Initially, the up-axis of the eye will be the same as the up-axis of the scene (or +Z if
        /// the scene has no up axis defined).
        std::optional<ComponentBatch> eye_up;

        /// Translation speed of the eye in the view (when using WASDQE keys to move in the 3D scene).
        ///
        /// The default depends on the control kind.
        /// For orbit cameras it is derived from the distance to the orbit center.
        /// For first person cameras it is derived from the scene size.
        std::optional<ComponentBatch> speed;

        /// Currently tracked entity.
        ///
        /// If this is a camera, it takes over the camera pose, otherwise follows the entity.
        std::optional<ComponentBatch> tracking_entity;

        /// What speed, if any, the camera should spin around the eye-up axis.
        ///
        /// Defaults to zero, meaning no spinning.
        std::optional<ComponentBatch> spin_speed;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.EyeControls3D";

        /// `ComponentDescriptor` for the `kind` field.
        static constexpr auto Descriptor_kind = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:kind",
            Loggable<rerun::blueprint::components::Eye3DKind>::ComponentType
        );
        /// `ComponentDescriptor` for the `position` field.
        static constexpr auto Descriptor_position = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:position",
            Loggable<rerun::components::Position3D>::ComponentType
        );
        /// `ComponentDescriptor` for the `look_target` field.
        static constexpr auto Descriptor_look_target = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:look_target",
            Loggable<rerun::components::Position3D>::ComponentType
        );
        /// `ComponentDescriptor` for the `eye_up` field.
        static constexpr auto Descriptor_eye_up = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:eye_up",
            Loggable<rerun::components::Vector3D>::ComponentType
        );
        /// `ComponentDescriptor` for the `speed` field.
        static constexpr auto Descriptor_speed = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:speed",
            Loggable<rerun::components::LinearSpeed>::ComponentType
        );
        /// `ComponentDescriptor` for the `tracking_entity` field.
        static constexpr auto Descriptor_tracking_entity = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:tracking_entity",
            Loggable<rerun::components::EntityPath>::ComponentType
        );
        /// `ComponentDescriptor` for the `spin_speed` field.
        static constexpr auto Descriptor_spin_speed = ComponentDescriptor(
            ArchetypeName, "EyeControls3D:spin_speed",
            Loggable<rerun::blueprint::components::AngularSpeed>::ComponentType
        );

      public:
        EyeControls3D() = default;
        EyeControls3D(EyeControls3D&& other) = default;
        EyeControls3D(const EyeControls3D& other) = default;
        EyeControls3D& operator=(const EyeControls3D& other) = default;
        EyeControls3D& operator=(EyeControls3D&& other) = default;

        /// Update only some specific fields of a `EyeControls3D`.
        static EyeControls3D update_fields() {
            return EyeControls3D();
        }

        /// Clear all the fields of a `EyeControls3D`.
        static EyeControls3D clear_fields();

        /// The kind of the eye for the spatial 3D view.
        ///
        /// This controls how the eye movement behaves when the user interact with the view.
        /// Defaults to orbital.
        EyeControls3D with_kind(const rerun::blueprint::components::Eye3DKind& _kind) && {
            kind = ComponentBatch::from_loggable(_kind, Descriptor_kind).value_or_throw();
            return std::move(*this);
        }

        /// The cameras current position.
        EyeControls3D with_position(const rerun::components::Position3D& _position) && {
            position =
                ComponentBatch::from_loggable(_position, Descriptor_position).value_or_throw();
            return std::move(*this);
        }

        /// The position the camera is currently looking at.
        ///
        /// If this is an orbital camera, this also is the center it orbits around.
        ///
        /// By default this is the center of the scene bounds.
        EyeControls3D with_look_target(const rerun::components::Position3D& _look_target) && {
            look_target = ComponentBatch::from_loggable(_look_target, Descriptor_look_target)
                              .value_or_throw();
            return std::move(*this);
        }

        /// The up-axis of the eye itself, in world-space.
        ///
        /// Initially, the up-axis of the eye will be the same as the up-axis of the scene (or +Z if
        /// the scene has no up axis defined).
        EyeControls3D with_eye_up(const rerun::components::Vector3D& _eye_up) && {
            eye_up = ComponentBatch::from_loggable(_eye_up, Descriptor_eye_up).value_or_throw();
            return std::move(*this);
        }

        /// Translation speed of the eye in the view (when using WASDQE keys to move in the 3D scene).
        ///
        /// The default depends on the control kind.
        /// For orbit cameras it is derived from the distance to the orbit center.
        /// For first person cameras it is derived from the scene size.
        EyeControls3D with_speed(const rerun::components::LinearSpeed& _speed) && {
            speed = ComponentBatch::from_loggable(_speed, Descriptor_speed).value_or_throw();
            return std::move(*this);
        }

        /// Currently tracked entity.
        ///
        /// If this is a camera, it takes over the camera pose, otherwise follows the entity.
        EyeControls3D with_tracking_entity(const rerun::components::EntityPath& _tracking_entity
        ) && {
            tracking_entity =
                ComponentBatch::from_loggable(_tracking_entity, Descriptor_tracking_entity)
                    .value_or_throw();
            return std::move(*this);
        }

        /// What speed, if any, the camera should spin around the eye-up axis.
        ///
        /// Defaults to zero, meaning no spinning.
        EyeControls3D with_spin_speed(const rerun::blueprint::components::AngularSpeed& _spin_speed
        ) && {
            spin_speed =
                ComponentBatch::from_loggable(_spin_speed, Descriptor_spin_speed).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::EyeControls3D> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::EyeControls3D& archetype
        );
    };
} // namespace rerun
