// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/blueprint/archetypes/tensor_view_fit.fbs".

#pragma once

#include "../../blueprint/components/view_fit.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Configures how a selected tensor slice is shown on screen.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct TensorViewFit {
        /// How the image is scaled to fit the view.
        std::optional<ComponentBatch> scaling;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] = "rerun.blueprint.archetypes.TensorViewFit";

        /// `ComponentDescriptor` for the `scaling` field.
        static constexpr auto Descriptor_scaling = ComponentDescriptor(
            ArchetypeName, "TensorViewFit:scaling",
            Loggable<rerun::blueprint::components::ViewFit>::ComponentType
        );

      public:
        TensorViewFit() = default;
        TensorViewFit(TensorViewFit&& other) = default;
        TensorViewFit(const TensorViewFit& other) = default;
        TensorViewFit& operator=(const TensorViewFit& other) = default;
        TensorViewFit& operator=(TensorViewFit&& other) = default;

        /// Update only some specific fields of a `TensorViewFit`.
        static TensorViewFit update_fields() {
            return TensorViewFit();
        }

        /// Clear all the fields of a `TensorViewFit`.
        static TensorViewFit clear_fields();

        /// How the image is scaled to fit the view.
        TensorViewFit with_scaling(const rerun::blueprint::components::ViewFit& _scaling) && {
            scaling = ComponentBatch::from_loggable(_scaling, Descriptor_scaling).value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::TensorViewFit> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::TensorViewFit& archetype
        );
    };
} // namespace rerun
