// DO NOT EDIT! This file was auto-generated by crates/build/re_types_builder/src/codegen/cpp/mod.rs
// Based on "crates/store/re_types/definitions/rerun/blueprint/archetypes/panel_blueprint.fbs".

#pragma once

#include "../../blueprint/components/absolute_time_range.hpp"
#include "../../blueprint/components/fps.hpp"
#include "../../blueprint/components/loop_mode.hpp"
#include "../../blueprint/components/panel_state.hpp"
#include "../../blueprint/components/play_state.hpp"
#include "../../blueprint/components/playback_speed.hpp"
#include "../../blueprint/components/timeline_name.hpp"
#include "../../collection.hpp"
#include "../../component_batch.hpp"
#include "../../component_column.hpp"
#include "../../result.hpp"

#include <cstdint>
#include <optional>
#include <utility>
#include <vector>

namespace rerun::blueprint::archetypes {
    /// **Archetype**: Time panel specific state.
    ///
    /// ⚠ **This type is _unstable_ and may change significantly in a way that the data won't be backwards compatible.**
    ///
    struct TimePanelBlueprint {
        /// Current state of the panel.
        std::optional<ComponentBatch> state;

        /// What timeline the panel is on.
        std::optional<ComponentBatch> timeline;

        /// A time playback speed multiplier.
        std::optional<ComponentBatch> playback_speed;

        /// Frames per second. Only applicable for sequence timelines.
        std::optional<ComponentBatch> fps;

        /// If the time is currently paused, playing, or following.
        ///
        /// Defaults to either playing or following, depending on the data source.
        std::optional<ComponentBatch> play_state;

        /// How the time should loop. A selection loop only works if there is also a `time_selection` passed.
        ///
        /// Defaults to off.
        std::optional<ComponentBatch> loop_mode;

        /// Selects a range of time on the time panel.
        std::optional<ComponentBatch> time_selection;

      public:
        /// The name of the archetype as used in `ComponentDescriptor`s.
        static constexpr const char ArchetypeName[] =
            "rerun.blueprint.archetypes.TimePanelBlueprint";

        /// `ComponentDescriptor` for the `state` field.
        static constexpr auto Descriptor_state = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:state",
            Loggable<rerun::blueprint::components::PanelState>::ComponentType
        );
        /// `ComponentDescriptor` for the `timeline` field.
        static constexpr auto Descriptor_timeline = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:timeline",
            Loggable<rerun::blueprint::components::TimelineName>::ComponentType
        );
        /// `ComponentDescriptor` for the `playback_speed` field.
        static constexpr auto Descriptor_playback_speed = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:playback_speed",
            Loggable<rerun::blueprint::components::PlaybackSpeed>::ComponentType
        );
        /// `ComponentDescriptor` for the `fps` field.
        static constexpr auto Descriptor_fps = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:fps",
            Loggable<rerun::blueprint::components::Fps>::ComponentType
        );
        /// `ComponentDescriptor` for the `play_state` field.
        static constexpr auto Descriptor_play_state = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:play_state",
            Loggable<rerun::blueprint::components::PlayState>::ComponentType
        );
        /// `ComponentDescriptor` for the `loop_mode` field.
        static constexpr auto Descriptor_loop_mode = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:loop_mode",
            Loggable<rerun::blueprint::components::LoopMode>::ComponentType
        );
        /// `ComponentDescriptor` for the `time_selection` field.
        static constexpr auto Descriptor_time_selection = ComponentDescriptor(
            ArchetypeName, "TimePanelBlueprint:time_selection",
            Loggable<rerun::blueprint::components::AbsoluteTimeRange>::ComponentType
        );

      public:
        TimePanelBlueprint() = default;
        TimePanelBlueprint(TimePanelBlueprint&& other) = default;
        TimePanelBlueprint(const TimePanelBlueprint& other) = default;
        TimePanelBlueprint& operator=(const TimePanelBlueprint& other) = default;
        TimePanelBlueprint& operator=(TimePanelBlueprint&& other) = default;

        /// Update only some specific fields of a `TimePanelBlueprint`.
        static TimePanelBlueprint update_fields() {
            return TimePanelBlueprint();
        }

        /// Clear all the fields of a `TimePanelBlueprint`.
        static TimePanelBlueprint clear_fields();

        /// Current state of the panel.
        TimePanelBlueprint with_state(const rerun::blueprint::components::PanelState& _state) && {
            state = ComponentBatch::from_loggable(_state, Descriptor_state).value_or_throw();
            return std::move(*this);
        }

        /// What timeline the panel is on.
        TimePanelBlueprint with_timeline(const rerun::blueprint::components::TimelineName& _timeline
        ) && {
            timeline =
                ComponentBatch::from_loggable(_timeline, Descriptor_timeline).value_or_throw();
            return std::move(*this);
        }

        /// A time playback speed multiplier.
        TimePanelBlueprint with_playback_speed(
            const rerun::blueprint::components::PlaybackSpeed& _playback_speed
        ) && {
            playback_speed =
                ComponentBatch::from_loggable(_playback_speed, Descriptor_playback_speed)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Frames per second. Only applicable for sequence timelines.
        TimePanelBlueprint with_fps(const rerun::blueprint::components::Fps& _fps) && {
            fps = ComponentBatch::from_loggable(_fps, Descriptor_fps).value_or_throw();
            return std::move(*this);
        }

        /// If the time is currently paused, playing, or following.
        ///
        /// Defaults to either playing or following, depending on the data source.
        TimePanelBlueprint with_play_state(
            const rerun::blueprint::components::PlayState& _play_state
        ) && {
            play_state =
                ComponentBatch::from_loggable(_play_state, Descriptor_play_state).value_or_throw();
            return std::move(*this);
        }

        /// How the time should loop. A selection loop only works if there is also a `time_selection` passed.
        ///
        /// Defaults to off.
        TimePanelBlueprint with_loop_mode(const rerun::blueprint::components::LoopMode& _loop_mode
        ) && {
            loop_mode =
                ComponentBatch::from_loggable(_loop_mode, Descriptor_loop_mode).value_or_throw();
            return std::move(*this);
        }

        /// Selects a range of time on the time panel.
        TimePanelBlueprint with_time_selection(
            const rerun::blueprint::components::AbsoluteTimeRange& _time_selection
        ) && {
            time_selection =
                ComponentBatch::from_loggable(_time_selection, Descriptor_time_selection)
                    .value_or_throw();
            return std::move(*this);
        }

        /// Partitions the component data into multiple sub-batches.
        ///
        /// Specifically, this transforms the existing `ComponentBatch` data into `ComponentColumn`s
        /// instead, via `ComponentBatch::partitioned`.
        ///
        /// This makes it possible to use `RecordingStream::send_columns` to send columnar data directly into Rerun.
        ///
        /// The specified `lengths` must sum to the total length of the component batch.
        Collection<ComponentColumn> columns(const Collection<uint32_t>& lengths_);

        /// Partitions the component data into unit-length sub-batches.
        ///
        /// This is semantically similar to calling `columns` with `std::vector<uint32_t>(n, 1)`,
        /// where `n` is automatically guessed.
        Collection<ComponentColumn> columns();
    };

} // namespace rerun::blueprint::archetypes

namespace rerun {
    /// \private
    template <typename T>
    struct AsComponents;

    /// \private
    template <>
    struct AsComponents<blueprint::archetypes::TimePanelBlueprint> {
        /// Serialize all set component batches.
        static Result<Collection<ComponentBatch>> as_batches(
            const blueprint::archetypes::TimePanelBlueprint& archetype
        );
    };
} // namespace rerun
